/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.SharedShortArrayReductionBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedShortArray;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedShortArrayBuf
extends ShortBuf {
    SharedShortArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedShortArrayBuf(SharedShortArray sharedShortArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= sharedShortArray.length()) {
            throw new IndexOutOfBoundsException("SharedShortArrayBuf(): theArray index range = 0.." + (sharedShortArray.length() - 1) + ", theRange = " + range);
        }
        this.myArray = sharedShortArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public short get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, short s) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, s);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedShortArrayReductionBuf(this.myArray, this.myRange, (ShortOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 2) {
            byteBuffer.putShort(this.myArray.get(n3));
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 2) {
            this.myArray.set(n4, byteBuffer.getShort());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

