/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.SharedLongArrayReductionBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedLongArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedLongArrayBuf
extends LongBuf {
    SharedLongArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedLongArrayBuf(SharedLongArray sharedLongArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= sharedLongArray.length()) {
            throw new IndexOutOfBoundsException("SharedLongArrayBuf(): theArray index range = 0.." + (sharedLongArray.length() - 1) + ", theRange = " + range);
        }
        this.myArray = sharedLongArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public long get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, long l) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, l);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedLongArrayReductionBuf(this.myArray, this.myRange, (LongOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 8) {
            byteBuffer.putLong(this.myArray.get(n3));
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 8) {
            this.myArray.set(n4, byteBuffer.getLong());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

