/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.SharedFloatReductionBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedFloat;
import java.nio.ByteBuffer;

public class SharedFloatBuf
extends FloatBuf {
    SharedFloat myItem;

    public SharedFloatBuf(SharedFloat sharedFloat) {
        super(1);
        if (sharedFloat == null) {
            throw new NullPointerException("SharedFloatBuf(): item is null");
        }
        this.myItem = sharedFloat;
    }

    public float get(int n) {
        return this.myItem.get();
    }

    public void put(int n, float f) {
        this.myItem.set(f);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedFloatReductionBuf(this.myItem, (FloatOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 4) {
            byteBuffer.putFloat(this.myItem.get());
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 4) {
            this.myItem.set(byteBuffer.getFloat());
            return 1;
        }
        return 0;
    }
}

