/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.SharedCharacterReductionBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedCharacter;
import java.nio.ByteBuffer;

public class SharedCharacterBuf
extends CharacterBuf {
    SharedCharacter myItem;

    public SharedCharacterBuf(SharedCharacter sharedCharacter) {
        super(1);
        if (sharedCharacter == null) {
            throw new NullPointerException("SharedCharacterBuf(): item is null");
        }
        this.myItem = sharedCharacter;
    }

    public char get(int n) {
        return this.myItem.get();
    }

    public void put(int n, char c) {
        this.myItem.set(c);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedCharacterReductionBuf(this.myItem, (CharacterOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 2) {
            byteBuffer.putChar(this.myItem.get());
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 2) {
            this.myItem.set(byteBuffer.getChar());
            return 1;
        }
        return 0;
    }
}

