/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.SharedByteReductionBuf;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedByte;
import java.nio.ByteBuffer;

public class SharedByteBuf
extends ByteBuf {
    SharedByte myItem;

    public SharedByteBuf(SharedByte sharedByte) {
        super(1);
        if (sharedByte == null) {
            throw new NullPointerException("SharedByteBuf(): item is null");
        }
        this.myItem = sharedByte;
    }

    public byte get(int n) {
        return this.myItem.get();
    }

    public void put(int n, byte by) {
        this.myItem.set(by);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedByteReductionBuf(this.myItem, (ByteOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 1) {
            byteBuffer.put(this.myItem.get());
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 1) {
            this.myItem.set(byteBuffer.get());
            return 1;
        }
        return 0;
    }
}

