/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.SharedByteArrayReductionBuf;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedByteArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedByteArrayBuf
extends ByteBuf {
    SharedByteArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedByteArrayBuf(SharedByteArray sharedByteArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= sharedByteArray.length()) {
            throw new IndexOutOfBoundsException("SharedByteArrayBuf(): theArray index range = 0.." + (sharedByteArray.length() - 1) + ", theRange = " + range);
        }
        this.myArray = sharedByteArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public byte get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, byte by) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, by);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedByteArrayReductionBuf(this.myArray, this.myRange, (ByteOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 1) {
            byteBuffer.put(this.myArray.get(n3));
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 1) {
            this.myArray.set(n4, byteBuffer.get());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

