/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectMatrixReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMatrixBuf<T>
extends ObjectBuf<T> {
    T[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public ObjectMatrixBuf(T[][] TArray, Range range, Range range2) {
        super(range.length() * range2.length());
        if (0 > range.lb() || range.ub() >= TArray.length) {
            throw new IndexOutOfBoundsException("ObjectMatrixBuf(): theMatrix row index range = 0.." + (TArray.length - 1) + ", theRowRange = " + range);
        }
        if (0 > range2.lb() || range2.ub() >= TArray[0].length) {
            throw new IndexOutOfBoundsException("ObjectMatrixBuf(): theMatrix column index range = 0.." + (TArray[0].length - 1) + ", theColRange = " + range2);
        }
        this.myMatrix = TArray;
        this.myRowRange = range;
        this.myColRange = range2;
        this.myLowerRow = range.lb();
        this.myRowCount = range.length();
        this.myRowStride = range.stride();
        this.myLowerCol = range2.lb();
        this.myColCount = range2.length();
        this.myColStride = range2.stride();
    }

    @Override
    public T get(int n) {
        return this.myMatrix[n / this.myColCount * this.myRowStride + this.myLowerRow][n % this.myColCount * this.myColStride + this.myLowerCol];
    }

    @Override
    public void put(int n, T t) {
        this.myMatrix[n / this.myColCount * this.myRowStride + this.myLowerRow][n % this.myColCount * this.myColStride + this.myLowerCol] = t;
        this.mySerializedItems = null;
    }

    @Override
    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ObjectMatrixBuf) {
                ObjectMatrixBuf objectMatrixBuf = (ObjectMatrixBuf)buf;
                Arrays.copy(objectMatrixBuf.myMatrix, objectMatrixBuf.myRowRange, objectMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)buf, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new ObjectMatrixReductionBuf<T>(this.myMatrix, this.myRowRange, this.myColRange, (ObjectOp)op);
    }
}

