/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectArrayReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayBuf<T>
extends ObjectBuf<T> {
    T[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public ObjectArrayBuf(T[] TArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= TArray.length) {
            throw new IndexOutOfBoundsException("ObjectArrayBuf(): theArray index range = 0.." + (TArray.length - 1) + ", theRange = " + range);
        }
        this.myArray = TArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    @Override
    public T get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    @Override
    public void put(int n, T t) {
        this.myArray[this.myArrayOffset + n * this.myStride] = t;
        this.mySerializedItems = null;
    }

    @Override
    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ObjectArrayBuf) {
                ObjectArrayBuf objectArrayBuf = (ObjectArrayBuf)buf;
                Arrays.copy(objectArrayBuf.myArray, objectArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)buf, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new ObjectArrayReductionBuf<T>(this.myArray, this.myRange, (ObjectOp)op);
    }
}

