/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class LongItemReductionBuf
extends LongBuf {
    LongItemBuf myBuf;
    LongOp myOp;

    public LongItemReductionBuf(LongItemBuf longItemBuf, LongOp longOp) {
        super(1);
        if (longItemBuf == null) {
            throw new NullPointerException("LongItemReductionBuf(): buf is null");
        }
        if (longOp == null) {
            throw new NullPointerException("LongItemReductionBuf(): op is null");
        }
        this.myBuf = longItemBuf;
        this.myOp = longOp;
    }

    public long get(int n) {
        return this.myBuf.item;
    }

    public void put(int n, long l) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, l);
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 8) {
            byteBuffer.putLong(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 8) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, byteBuffer.getLong());
            return 1;
        }
        return 0;
    }
}

