/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerMatrixBuf;
import edu.rit.mp.buf.IntegerMatrixBuf_1;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class IntegerMatrixReductionBuf_1
extends IntegerMatrixBuf_1 {
    IntegerOp myOp;

    public IntegerMatrixReductionBuf_1(int[][] nArray, Range range, Range range2, IntegerOp integerOp) {
        super(nArray, range, range2);
        if (integerOp == null) {
            throw new NullPointerException("IntegerMatrixReductionBuf_1(): op is null");
        }
        this.myOp = integerOp;
    }

    public void put(int n, int n2) {
        int n3 = n / this.myColCount + this.myLowerRow;
        int n4 = n % this.myColCount + this.myLowerCol;
        this.myMatrix[n3][n4] = this.myOp.op(this.myMatrix[n3][n4], n2);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof IntegerMatrixBuf) {
                IntegerMatrixBuf integerMatrixBuf = (IntegerMatrixBuf)buf;
                ReduceArrays.reduce(integerMatrixBuf.myMatrix, integerMatrixBuf.myRowRange, integerMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                IntegerBuf.defaultCopy((IntegerBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, intBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            int[] nArray = this.myMatrix[n5];
            while (n6 < n8) {
                nArray[n7] = this.myOp.op(nArray[n7], intBuffer.get());
                ++n6;
                ++n7;
            }
            n3 += n8;
            ++n4;
            ++n5;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, intBuffer.remaining());
        }
        byteBuffer.position(byteBuffer.position() + 4 * n3);
        return n3;
    }
}

