/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.FloatBuf;
import edu.rit.mp.buf.FloatItemBuf;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class FloatItemReductionBuf
extends FloatBuf {
    FloatItemBuf myBuf;
    FloatOp myOp;

    public FloatItemReductionBuf(FloatItemBuf floatItemBuf, FloatOp floatOp) {
        super(1);
        if (floatItemBuf == null) {
            throw new NullPointerException("FloatItemReductionBuf(): buf is null");
        }
        if (floatOp == null) {
            throw new NullPointerException("FloatItemReductionBuf(): op is null");
        }
        this.myBuf = floatItemBuf;
        this.myOp = floatOp;
    }

    public float get(int n) {
        return this.myBuf.item;
    }

    public void put(int n, float f) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, f);
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 4) {
            byteBuffer.putFloat(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 4) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, byteBuffer.getFloat());
            return 1;
        }
        return 0;
    }
}

