/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleMatrixBuf;
import edu.rit.mp.buf.DoubleMatrixBuf_1;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;

class DoubleMatrixReductionBuf_1
extends DoubleMatrixBuf_1 {
    DoubleOp myOp;

    public DoubleMatrixReductionBuf_1(double[][] dArray, Range range, Range range2, DoubleOp doubleOp) {
        super(dArray, range, range2);
        if (doubleOp == null) {
            throw new NullPointerException("DoubleMatrixReductionBuf_1(): op is null");
        }
        this.myOp = doubleOp;
    }

    public void put(int n, double d) {
        int n2 = n / this.myColCount + this.myLowerRow;
        int n3 = n % this.myColCount + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], d);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof DoubleMatrixBuf) {
                DoubleMatrixBuf doubleMatrixBuf = (DoubleMatrixBuf)buf;
                ReduceArrays.reduce(doubleMatrixBuf.myMatrix, doubleMatrixBuf.myRowRange, doubleMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                DoubleBuf.defaultCopy((DoubleBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, doubleBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            double[] dArray = this.myMatrix[n5];
            while (n6 < n8) {
                dArray[n7] = this.myOp.op(dArray[n7], doubleBuffer.get());
                ++n6;
                ++n7;
            }
            n3 += n8;
            ++n4;
            ++n5;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, doubleBuffer.remaining());
        }
        byteBuffer.position(byteBuffer.position() + 8 * n3);
        return n3;
    }
}

