/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterMatrixReductionBuf;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class CharacterMatrixBuf
extends CharacterBuf {
    char[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public CharacterMatrixBuf(char[][] cArray, Range range, Range range2) {
        super(range.length() * range2.length());
        if (0 > range.lb() || range.ub() >= cArray.length) {
            throw new IndexOutOfBoundsException("CharacterMatrixBuf(): theMatrix row index range = 0.." + (cArray.length - 1) + ", theRowRange = " + range);
        }
        if (0 > range2.lb() || range2.ub() >= cArray[0].length) {
            throw new IndexOutOfBoundsException("CharacterMatrixBuf(): theMatrix column index range = 0.." + (cArray[0].length - 1) + ", theColRange = " + range2);
        }
        this.myMatrix = cArray;
        this.myRowRange = range;
        this.myColRange = range2;
        this.myLowerRow = range.lb();
        this.myRowCount = range.length();
        this.myRowStride = range.stride();
        this.myLowerCol = range2.lb();
        this.myColCount = range2.length();
        this.myColStride = range2.stride();
    }

    public char get(int n) {
        return this.myMatrix[n / this.myColCount * this.myRowStride + this.myLowerRow][n % this.myColCount * this.myColStride + this.myLowerCol];
    }

    public void put(int n, char c) {
        this.myMatrix[n / this.myColCount * this.myRowStride + this.myLowerRow][n % this.myColCount * this.myColStride + this.myLowerCol] = c;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof CharacterMatrixBuf) {
                CharacterMatrixBuf characterMatrixBuf = (CharacterMatrixBuf)buf;
                Arrays.copy(characterMatrixBuf.myMatrix, characterMatrixBuf.myRowRange, characterMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
            } else {
                CharacterBuf.defaultCopy((CharacterBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new CharacterMatrixReductionBuf(this.myMatrix, this.myRowRange, this.myColRange, (CharacterOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        int n2 = 0;
        int n3 = n / this.myColCount;
        int n4 = n3 * this.myRowStride + this.myLowerRow;
        int n5 = n % this.myColCount;
        int n6 = n5 * this.myColStride + this.myLowerCol;
        int n7 = Math.min(this.myColCount - n5, charBuffer.remaining());
        while (n3 < this.myRowCount && n7 > 0) {
            char[] cArray = this.myMatrix[n4];
            while (n5 < n7) {
                charBuffer.put(cArray[n6]);
                ++n5;
                n6 += this.myColStride;
            }
            n2 += n7;
            ++n3;
            n4 += this.myRowStride;
            n5 = 0;
            n6 = this.myLowerCol;
            n7 = Math.min(this.myColCount, charBuffer.remaining());
        }
        byteBuffer.position(byteBuffer.position() + 2 * n2);
        return n2;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, charBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            char[] cArray = this.myMatrix[n5];
            while (n6 < n8) {
                cArray[n7] = charBuffer.get();
                ++n6;
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, charBuffer.remaining());
        }
        byteBuffer.position(byteBuffer.position() + 2 * n3);
        return n3;
    }
}

