/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.ByteMatrixReductionBuf;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class ByteMatrixBuf
extends ByteBuf {
    byte[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public ByteMatrixBuf(byte[][] byArray, Range range, Range range2) {
        super(range.length() * range2.length());
        if (0 > range.lb() || range.ub() >= byArray.length) {
            throw new IndexOutOfBoundsException("ByteMatrixBuf(): theMatrix row index range = 0.." + (byArray.length - 1) + ", theRowRange = " + range);
        }
        if (0 > range2.lb() || range2.ub() >= byArray[0].length) {
            throw new IndexOutOfBoundsException("ByteMatrixBuf(): theMatrix column index range = 0.." + (byArray[0].length - 1) + ", theColRange = " + range2);
        }
        this.myMatrix = byArray;
        this.myRowRange = range;
        this.myColRange = range2;
        this.myLowerRow = range.lb();
        this.myRowCount = range.length();
        this.myRowStride = range.stride();
        this.myLowerCol = range2.lb();
        this.myColCount = range2.length();
        this.myColStride = range2.stride();
    }

    public byte get(int n) {
        return this.myMatrix[n / this.myColCount * this.myRowStride + this.myLowerRow][n % this.myColCount * this.myColStride + this.myLowerCol];
    }

    public void put(int n, byte by) {
        this.myMatrix[n / this.myColCount * this.myRowStride + this.myLowerRow][n % this.myColCount * this.myColStride + this.myLowerCol] = by;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ByteMatrixBuf) {
                ByteMatrixBuf byteMatrixBuf = (ByteMatrixBuf)buf;
                Arrays.copy(byteMatrixBuf.myMatrix, byteMatrixBuf.myRowRange, byteMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
            } else {
                ByteBuf.defaultCopy((ByteBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new ByteMatrixReductionBuf(this.myMatrix, this.myRowRange, this.myColRange, (ByteOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = 0;
        int n3 = n / this.myColCount;
        int n4 = n3 * this.myRowStride + this.myLowerRow;
        int n5 = n % this.myColCount;
        int n6 = n5 * this.myColStride + this.myLowerCol;
        int n7 = Math.min(this.myColCount - n5, byteBuffer.remaining());
        while (n3 < this.myRowCount && n7 > 0) {
            byte[] byArray = this.myMatrix[n4];
            while (n5 < n7) {
                byteBuffer.put(byArray[n6]);
                ++n5;
                n6 += this.myColStride;
            }
            n2 += n7;
            ++n3;
            n4 += this.myRowStride;
            n5 = 0;
            n6 = this.myLowerCol;
            n7 = Math.min(this.myColCount, byteBuffer.remaining());
        }
        return n2;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, byteBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            byte[] byArray = this.myMatrix[n5];
            while (n6 < n8) {
                byArray[n7] = byteBuffer.get();
                ++n6;
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, byteBuffer.remaining());
        }
        return n3;
    }
}

