/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanMatrixBuf;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class BooleanMatrixReductionBuf
extends BooleanMatrixBuf {
    BooleanOp myOp;

    public BooleanMatrixReductionBuf(boolean[][] blArray, Range range, Range range2, BooleanOp booleanOp) {
        super(blArray, range, range2);
        if (booleanOp == null) {
            throw new NullPointerException("BooleanMatrixReductionBuf(): op is null");
        }
        this.myOp = booleanOp;
    }

    public void put(int n, boolean bl) {
        int n2 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n3 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], bl);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof BooleanMatrixBuf) {
                BooleanMatrixBuf booleanMatrixBuf = (BooleanMatrixBuf)buf;
                ReduceArrays.reduce(booleanMatrixBuf.myMatrix, booleanMatrixBuf.myRowRange, booleanMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                BooleanBuf.defaultCopy((BooleanBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, byteBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            boolean[] blArray = this.myMatrix[n5];
            while (n6 < n8) {
                blArray[n7] = this.myOp.op(blArray[n7], byteBuffer.get() != 0);
                ++n6;
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, byteBuffer.remaining());
        }
        return n3;
    }
}

