/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanArrayReductionBuf;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class BooleanArrayBuf
extends BooleanBuf {
    boolean[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public BooleanArrayBuf(boolean[] blArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= blArray.length) {
            throw new IndexOutOfBoundsException("BooleanArrayBuf(): theArray index range = 0.." + (blArray.length - 1) + ", theRange = " + range);
        }
        this.myArray = blArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public boolean get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, boolean bl) {
        this.myArray[this.myArrayOffset + n * this.myStride] = bl;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof BooleanArrayBuf) {
                BooleanArrayBuf booleanArrayBuf = (BooleanArrayBuf)buf;
                Arrays.copy(booleanArrayBuf.myArray, booleanArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                BooleanBuf.defaultCopy((BooleanBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new BooleanArrayReductionBuf(this.myArray, this.myRange, (BooleanOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 1) {
            byteBuffer.put(this.myArray[n3] ? (byte)1 : 0);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 1) {
            this.myArray[n4] = byteBuffer.get() != 0;
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

