/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.ChannelClosedException;
import edu.rit.mp.IORequest;
import edu.rit.mp.NetworkChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetworkChannelSendThread
extends Thread {
    private NetworkChannel myNetworkChannel;
    private SocketChannel mySocketChannel;
    private LinkedBlockingQueue<IORequest> myOutgoingQueue;
    private ByteBuffer myByteBuffer;

    NetworkChannelSendThread(NetworkChannel networkChannel, SocketChannel socketChannel, LinkedBlockingQueue<IORequest> linkedBlockingQueue) {
        this.myNetworkChannel = networkChannel;
        this.mySocketChannel = socketChannel;
        this.myOutgoingQueue = linkedBlockingQueue;
        this.myByteBuffer = ByteBuffer.allocateDirect(29040);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        IORequest iORequest = null;
        Buf buf = null;
        while (true) {
            try {
                while (true) {
                    iORequest = this.myOutgoingQueue.take();
                    buf = iORequest.myBuf;
                    buf.preSend();
                    this.myByteBuffer.clear();
                    int n = buf.myMessageLength;
                    this.myByteBuffer.putInt(30144596);
                    this.myByteBuffer.putInt(iORequest.myMessageTag);
                    this.myByteBuffer.put(buf.myMessageType);
                    this.myByteBuffer.putInt(n);
                    for (int i = 0; i < n; i += buf.sendItems(i, this.myByteBuffer)) {
                        this.myByteBuffer.flip();
                        this.mySocketChannel.write(this.myByteBuffer);
                        this.myByteBuffer.compact();
                    }
                    this.myByteBuffer.flip();
                    while (this.myByteBuffer.hasRemaining()) {
                        this.mySocketChannel.write(this.myByteBuffer);
                        this.myByteBuffer.compact();
                        this.myByteBuffer.flip();
                    }
                    buf.postSend();
                    iORequest.reportSuccess();
                    iORequest = null;
                    buf = null;
                }
            }
            catch (IOException iOException) {
                if (iORequest == null) continue;
                iORequest.reportFailure(iOException);
                continue;
            }
            catch (InterruptedException interruptedException) {
                ChannelClosedException channelClosedException = new ChannelClosedException("Channel closed");
                if (iORequest != null) {
                    iORequest.reportFailure(channelClosedException);
                }
                while ((iORequest = this.myOutgoingQueue.poll()) != null) {
                    iORequest.reportFailure(channelClosedException);
                }
            }
            catch (RuntimeException runtimeException) {
                if (iORequest == null) continue;
                iORequest.reportFailure(runtimeException);
                continue;
            }
            catch (Error error) {
                if (iORequest == null) continue;
                iORequest.reportFailure(error);
                continue;
            }
            break;
        }
        this.myNetworkChannel = null;
        this.mySocketChannel = null;
        this.myOutgoingQueue = null;
        this.myByteBuffer = null;
    }
}

