/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.LongArrayBuf;
import edu.rit.mp.buf.LongArrayBuf_1;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.mp.buf.LongMatrixBuf;
import edu.rit.mp.buf.LongMatrixBuf_1;
import edu.rit.mp.buf.SharedLongArrayBuf;
import edu.rit.mp.buf.SharedLongArrayBuf_1;
import edu.rit.mp.buf.SharedLongBuf;
import edu.rit.pj.reduction.SharedLong;
import edu.rit.pj.reduction.SharedLongArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class LongBuf
extends Buf {
    protected LongBuf(int n) {
        super((byte)5, n);
    }

    public static LongItemBuf buffer() {
        return new LongItemBuf();
    }

    public static LongItemBuf buffer(long l) {
        return new LongItemBuf(l);
    }

    public static LongBuf buffer(long[] lArray) {
        return new LongArrayBuf_1(lArray, new Range(0, lArray.length - 1));
    }

    public static LongBuf sliceBuffer(long[] lArray, Range range) {
        if (range.stride() == 1) {
            return new LongArrayBuf_1(lArray, range);
        }
        return new LongArrayBuf(lArray, range);
    }

    public static LongBuf[] sliceBuffers(long[] lArray, Range[] rangeArray) {
        int n = rangeArray.length;
        LongBuf[] longBufArray = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            longBufArray[i] = LongBuf.sliceBuffer(lArray, rangeArray[i]);
        }
        return longBufArray;
    }

    public static LongBuf buffer(long[][] lArray) {
        return new LongMatrixBuf_1(lArray, new Range(0, lArray.length - 1), new Range(0, lArray[0].length - 1));
    }

    public static LongBuf rowSliceBuffer(long[][] lArray, Range range) {
        if (range.stride() == 1) {
            return new LongMatrixBuf_1(lArray, range, new Range(0, lArray[0].length - 1));
        }
        return new LongMatrixBuf(lArray, range, new Range(0, lArray[0].length - 1));
    }

    public static LongBuf[] rowSliceBuffers(long[][] lArray, Range[] rangeArray) {
        int n = rangeArray.length;
        LongBuf[] longBufArray = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            longBufArray[i] = LongBuf.rowSliceBuffer(lArray, rangeArray[i]);
        }
        return longBufArray;
    }

    public static LongBuf colSliceBuffer(long[][] lArray, Range range) {
        if (range.stride() == 1) {
            return new LongMatrixBuf_1(lArray, new Range(0, lArray.length - 1), range);
        }
        return new LongMatrixBuf(lArray, new Range(0, lArray.length - 1), range);
    }

    public static LongBuf[] colSliceBuffers(long[][] lArray, Range[] rangeArray) {
        int n = rangeArray.length;
        LongBuf[] longBufArray = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            longBufArray[i] = LongBuf.colSliceBuffer(lArray, rangeArray[i]);
        }
        return longBufArray;
    }

    public static LongBuf patchBuffer(long[][] lArray, Range range, Range range2) {
        if (range.stride() == 1 && range2.stride() == 1) {
            return new LongMatrixBuf_1(lArray, range, range2);
        }
        return new LongMatrixBuf(lArray, range, range2);
    }

    public static LongBuf[] patchBuffers(long[][] lArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        LongBuf[] longBufArray = new LongBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                longBufArray[n3++] = LongBuf.patchBuffer(lArray, range, rangeArray2[j]);
            }
        }
        return longBufArray;
    }

    public static LongBuf buffer(SharedLong sharedLong) {
        return new SharedLongBuf(sharedLong);
    }

    public static LongBuf buffer(SharedLongArray sharedLongArray) {
        return new SharedLongArrayBuf_1(sharedLongArray, new Range(0, sharedLongArray.length() - 1));
    }

    public static LongBuf sliceBuffer(SharedLongArray sharedLongArray, Range range) {
        if (range.stride() == 1) {
            return new SharedLongArrayBuf_1(sharedLongArray, range);
        }
        return new SharedLongArrayBuf(sharedLongArray, range);
    }

    public static LongBuf[] sliceBuffers(SharedLongArray sharedLongArray, Range[] rangeArray) {
        int n = rangeArray.length;
        LongBuf[] longBufArray = new LongBuf[n];
        for (int i = 0; i < n; ++i) {
            longBufArray[i] = LongBuf.sliceBuffer(sharedLongArray, rangeArray[i]);
        }
        return longBufArray;
    }

    public abstract long get(int var1);

    public abstract void put(int var1, long var2);

    public void copy(Buf buf) {
        if (buf != this) {
            LongBuf.defaultCopy((LongBuf)buf, this);
        }
    }

    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining() / 8);
        byteBuffer.position(byteBuffer.position() + 8 * n2);
        return n2;
    }

    protected static void defaultCopy(LongBuf longBuf, LongBuf longBuf2) {
        int n = Math.min(longBuf.myLength, longBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            longBuf2.put(i, longBuf.get(i));
        }
    }
}

