/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.IntegerArrayBuf;
import edu.rit.mp.buf.IntegerArrayBuf_1;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.mp.buf.IntegerMatrixBuf;
import edu.rit.mp.buf.IntegerMatrixBuf_1;
import edu.rit.mp.buf.SharedIntegerArrayBuf;
import edu.rit.mp.buf.SharedIntegerArrayBuf_1;
import edu.rit.mp.buf.SharedIntegerBuf;
import edu.rit.pj.reduction.SharedInteger;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class IntegerBuf
extends Buf {
    protected IntegerBuf(int n) {
        super((byte)4, n);
    }

    public static IntegerItemBuf buffer() {
        return new IntegerItemBuf();
    }

    public static IntegerItemBuf buffer(int n) {
        return new IntegerItemBuf(n);
    }

    public static IntegerBuf buffer(int[] nArray) {
        return new IntegerArrayBuf_1(nArray, new Range(0, nArray.length - 1));
    }

    public static IntegerBuf sliceBuffer(int[] nArray, Range range) {
        if (range.stride() == 1) {
            return new IntegerArrayBuf_1(nArray, range);
        }
        return new IntegerArrayBuf(nArray, range);
    }

    public static IntegerBuf[] sliceBuffers(int[] nArray, Range[] rangeArray) {
        int n = rangeArray.length;
        IntegerBuf[] integerBufArray = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            integerBufArray[i] = IntegerBuf.sliceBuffer(nArray, rangeArray[i]);
        }
        return integerBufArray;
    }

    public static IntegerBuf buffer(int[][] nArray) {
        return new IntegerMatrixBuf_1(nArray, new Range(0, nArray.length - 1), new Range(0, nArray[0].length - 1));
    }

    public static IntegerBuf rowSliceBuffer(int[][] nArray, Range range) {
        if (range.stride() == 1) {
            return new IntegerMatrixBuf_1(nArray, range, new Range(0, nArray[0].length - 1));
        }
        return new IntegerMatrixBuf(nArray, range, new Range(0, nArray[0].length - 1));
    }

    public static IntegerBuf[] rowSliceBuffers(int[][] nArray, Range[] rangeArray) {
        int n = rangeArray.length;
        IntegerBuf[] integerBufArray = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            integerBufArray[i] = IntegerBuf.rowSliceBuffer(nArray, rangeArray[i]);
        }
        return integerBufArray;
    }

    public static IntegerBuf colSliceBuffer(int[][] nArray, Range range) {
        if (range.stride() == 1) {
            return new IntegerMatrixBuf_1(nArray, new Range(0, nArray.length - 1), range);
        }
        return new IntegerMatrixBuf(nArray, new Range(0, nArray.length - 1), range);
    }

    public static IntegerBuf[] colSliceBuffers(int[][] nArray, Range[] rangeArray) {
        int n = rangeArray.length;
        IntegerBuf[] integerBufArray = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            integerBufArray[i] = IntegerBuf.colSliceBuffer(nArray, rangeArray[i]);
        }
        return integerBufArray;
    }

    public static IntegerBuf patchBuffer(int[][] nArray, Range range, Range range2) {
        if (range.stride() == 1 && range2.stride() == 1) {
            return new IntegerMatrixBuf_1(nArray, range, range2);
        }
        return new IntegerMatrixBuf(nArray, range, range2);
    }

    public static IntegerBuf[] patchBuffers(int[][] nArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        IntegerBuf[] integerBufArray = new IntegerBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                integerBufArray[n3++] = IntegerBuf.patchBuffer(nArray, range, rangeArray2[j]);
            }
        }
        return integerBufArray;
    }

    public static IntegerBuf buffer(SharedInteger sharedInteger) {
        return new SharedIntegerBuf(sharedInteger);
    }

    public static IntegerBuf buffer(SharedIntegerArray sharedIntegerArray) {
        return new SharedIntegerArrayBuf_1(sharedIntegerArray, new Range(0, sharedIntegerArray.length() - 1));
    }

    public static IntegerBuf sliceBuffer(SharedIntegerArray sharedIntegerArray, Range range) {
        if (range.stride() == 1) {
            return new SharedIntegerArrayBuf_1(sharedIntegerArray, range);
        }
        return new SharedIntegerArrayBuf(sharedIntegerArray, range);
    }

    public static IntegerBuf[] sliceBuffers(SharedIntegerArray sharedIntegerArray, Range[] rangeArray) {
        int n = rangeArray.length;
        IntegerBuf[] integerBufArray = new IntegerBuf[n];
        for (int i = 0; i < n; ++i) {
            integerBufArray[i] = IntegerBuf.sliceBuffer(sharedIntegerArray, rangeArray[i]);
        }
        return integerBufArray;
    }

    public abstract int get(int var1);

    public abstract void put(int var1, int var2);

    public void copy(Buf buf) {
        if (buf != this) {
            IntegerBuf.defaultCopy((IntegerBuf)buf, this);
        }
    }

    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining() / 4);
        byteBuffer.position(byteBuffer.position() + 4 * n2);
        return n2;
    }

    protected static void defaultCopy(IntegerBuf integerBuf, IntegerBuf integerBuf2) {
        int n = Math.min(integerBuf.myLength, integerBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            integerBuf2.put(i, integerBuf.get(i));
        }
    }
}

