/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.IOCompletionHook;
import edu.rit.mp.Status;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;

public class IORequest {
    Channel myChannel;
    Integer myMessageTag;
    Buf myBuf;
    Status myStatus;
    IOException myIOException;
    RuntimeException myRuntimeException;
    Error myError;
    int myState = 0;
    static final int PENDING = 0;
    static final int SUCCEEDED = 1;
    static final int FAILED = 2;
    IORequest myChainedRequest;
    IOCompletionHook myCompletionHook;

    IORequest(Channel channel, Integer n, Buf buf) {
        this(channel, n, buf, null);
    }

    IORequest(Channel channel, Integer n, Buf buf, IOCompletionHook iOCompletionHook) {
        this.myChannel = channel;
        this.myMessageTag = n;
        this.myBuf = buf;
        this.myCompletionHook = iOCompletionHook;
    }

    public synchronized boolean isFinished() throws IOException {
        if (this.myState == 0) {
            return false;
        }
        this.rethrow("IORequest: Exception during send or receive");
        return this.myChainedRequest == null ? true : this.myChainedRequest.isFinished();
    }

    public synchronized Status waitForFinish() throws IOException {
        try {
            while (this.myState == 0) {
                this.wait();
            }
            this.rethrow("IORequest: Exception during send or receive");
            if (this.myChainedRequest != null) {
                this.myChainedRequest.waitForFinish();
            }
            return this.myStatus;
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("IORequest: waitForFinish() interrupted");
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
    }

    public synchronized void chain(IORequest iORequest) {
        if (iORequest == null) {
            throw new NullPointerException("IORequest.chain(): theIORequest is null");
        }
        if (this.myChainedRequest != null) {
            throw new IllegalStateException("IORequest.chain(): Another I/O request already chained");
        }
        this.myChainedRequest = iORequest;
    }

    boolean match(IORequest iORequest) {
        return !(this.myChannel != null && iORequest.myChannel != null && this.myChannel != iORequest.myChannel || this.myMessageTag != null && iORequest.myMessageTag != null && !this.myMessageTag.equals(iORequest.myMessageTag) || this.myBuf.myMessageType != iORequest.myBuf.myMessageType);
    }

    boolean match(Channel channel, Integer n, byte by) {
        return !(this.myChannel != null && channel != null && this.myChannel != channel || this.myMessageTag != null && n != null && !this.myMessageTag.equals(n) || this.myBuf.myMessageType != by);
    }

    synchronized void reportSuccess() {
        try {
            if (this.myCompletionHook != null) {
                this.myCompletionHook.finished(this, this.myStatus);
            }
            this.myState = 1;
            this.notifyAll();
        }
        catch (IOException iOException) {
            this.reportFailure(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.reportFailure(runtimeException);
        }
        catch (Error error) {
            this.reportFailure(error);
        }
    }

    synchronized void reportFailure(IOException iOException) {
        this.myIOException = iOException;
        this.myState = 2;
        this.notifyAll();
    }

    synchronized void reportFailure(RuntimeException runtimeException) {
        this.myRuntimeException = runtimeException;
        this.myState = 2;
        this.notifyAll();
    }

    synchronized void reportFailure(Error error) {
        this.myError = error;
        this.myState = 2;
        this.notifyAll();
    }

    private void rethrow(String string) throws IOException {
        if (this.myIOException != null) {
            this.rethrowIOException(string);
        } else if (this.myRuntimeException != null) {
            this.rethrowRuntimeException(string);
        } else if (this.myError != null) {
            this.rethrowError(string);
        }
    }

    private void rethrowIOException(String string) throws IOException {
        IOException iOException = null;
        try {
            Class<?> clazz = this.myIOException.getClass();
            Constructor<?> constructor = clazz.getConstructor(String.class);
            iOException = (IOException)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            iOException = new IOException(string);
        }
        iOException.initCause(this.myIOException);
        throw iOException;
    }

    private void rethrowRuntimeException(String string) {
        RuntimeException runtimeException = null;
        try {
            Class<?> clazz = this.myRuntimeException.getClass();
            Constructor<?> constructor = clazz.getConstructor(String.class);
            runtimeException = (RuntimeException)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            runtimeException = new RuntimeException(string);
        }
        runtimeException.initCause(this.myRuntimeException);
        throw runtimeException;
    }

    private void rethrowError(String string) {
        Error error = null;
        try {
            Class<?> clazz = this.myError.getClass();
            Constructor<?> constructor = clazz.getConstructor(String.class);
            error = (Error)constructor.newInstance(string);
        }
        catch (Throwable throwable) {
            error = new Error(string);
        }
        error.initCause(this.myError);
        throw error;
    }
}

