/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.DoubleArrayBuf;
import edu.rit.mp.buf.DoubleArrayBuf_1;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.mp.buf.DoubleMatrixBuf;
import edu.rit.mp.buf.DoubleMatrixBuf_1;
import edu.rit.mp.buf.SharedDoubleArrayBuf;
import edu.rit.mp.buf.SharedDoubleArrayBuf_1;
import edu.rit.mp.buf.SharedDoubleBuf;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedDoubleArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class DoubleBuf
extends Buf {
    protected DoubleBuf(int n) {
        super((byte)8, n);
    }

    public static DoubleItemBuf buffer() {
        return new DoubleItemBuf();
    }

    public static DoubleItemBuf buffer(double d) {
        return new DoubleItemBuf(d);
    }

    public static DoubleBuf buffer(double[] dArray) {
        return new DoubleArrayBuf_1(dArray, new Range(0, dArray.length - 1));
    }

    public static DoubleBuf sliceBuffer(double[] dArray, Range range) {
        if (range.stride() == 1) {
            return new DoubleArrayBuf_1(dArray, range);
        }
        return new DoubleArrayBuf(dArray, range);
    }

    public static DoubleBuf[] sliceBuffers(double[] dArray, Range[] rangeArray) {
        int n = rangeArray.length;
        DoubleBuf[] doubleBufArray = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            doubleBufArray[i] = DoubleBuf.sliceBuffer(dArray, rangeArray[i]);
        }
        return doubleBufArray;
    }

    public static DoubleBuf buffer(double[][] dArray) {
        return new DoubleMatrixBuf_1(dArray, new Range(0, dArray.length - 1), new Range(0, dArray[0].length - 1));
    }

    public static DoubleBuf rowSliceBuffer(double[][] dArray, Range range) {
        if (range.stride() == 1) {
            return new DoubleMatrixBuf_1(dArray, range, new Range(0, dArray[0].length - 1));
        }
        return new DoubleMatrixBuf(dArray, range, new Range(0, dArray[0].length - 1));
    }

    public static DoubleBuf[] rowSliceBuffers(double[][] dArray, Range[] rangeArray) {
        int n = rangeArray.length;
        DoubleBuf[] doubleBufArray = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            doubleBufArray[i] = DoubleBuf.rowSliceBuffer(dArray, rangeArray[i]);
        }
        return doubleBufArray;
    }

    public static DoubleBuf colSliceBuffer(double[][] dArray, Range range) {
        if (range.stride() == 1) {
            return new DoubleMatrixBuf_1(dArray, new Range(0, dArray.length - 1), range);
        }
        return new DoubleMatrixBuf(dArray, new Range(0, dArray.length - 1), range);
    }

    public static DoubleBuf[] colSliceBuffers(double[][] dArray, Range[] rangeArray) {
        int n = rangeArray.length;
        DoubleBuf[] doubleBufArray = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            doubleBufArray[i] = DoubleBuf.colSliceBuffer(dArray, rangeArray[i]);
        }
        return doubleBufArray;
    }

    public static DoubleBuf patchBuffer(double[][] dArray, Range range, Range range2) {
        if (range.stride() == 1 && range2.stride() == 1) {
            return new DoubleMatrixBuf_1(dArray, range, range2);
        }
        return new DoubleMatrixBuf(dArray, range, range2);
    }

    public static DoubleBuf[] patchBuffers(double[][] dArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        DoubleBuf[] doubleBufArray = new DoubleBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                doubleBufArray[n3++] = DoubleBuf.patchBuffer(dArray, range, rangeArray2[j]);
            }
        }
        return doubleBufArray;
    }

    public static DoubleBuf buffer(SharedDouble sharedDouble) {
        return new SharedDoubleBuf(sharedDouble);
    }

    public static DoubleBuf buffer(SharedDoubleArray sharedDoubleArray) {
        return new SharedDoubleArrayBuf_1(sharedDoubleArray, new Range(0, sharedDoubleArray.length() - 1));
    }

    public static DoubleBuf sliceBuffer(SharedDoubleArray sharedDoubleArray, Range range) {
        if (range.stride() == 1) {
            return new SharedDoubleArrayBuf_1(sharedDoubleArray, range);
        }
        return new SharedDoubleArrayBuf(sharedDoubleArray, range);
    }

    public static DoubleBuf[] sliceBuffers(SharedDoubleArray sharedDoubleArray, Range[] rangeArray) {
        int n = rangeArray.length;
        DoubleBuf[] doubleBufArray = new DoubleBuf[n];
        for (int i = 0; i < n; ++i) {
            doubleBufArray[i] = DoubleBuf.sliceBuffer(sharedDoubleArray, rangeArray[i]);
        }
        return doubleBufArray;
    }

    public abstract double get(int var1);

    public abstract void put(int var1, double var2);

    public void copy(Buf buf) {
        if (buf != this) {
            DoubleBuf.defaultCopy((DoubleBuf)buf, this);
        }
    }

    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining() / 8);
        byteBuffer.position(byteBuffer.position() + 8 * n2);
        return n2;
    }

    protected static void defaultCopy(DoubleBuf doubleBuf, DoubleBuf doubleBuf2) {
        int n = Math.min(doubleBuf.myLength, doubleBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            doubleBuf2.put(i, doubleBuf.get(i));
        }
    }
}

