/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.IOCompletionHook;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import edu.rit.mp.LoopbackChannel;
import edu.rit.mp.NetworkChannel;
import edu.rit.mp.Status;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;

public class ChannelGroup {
    ServerSocketChannel myServerSocketChannel;
    IORequestList myIORequestList = new IORequestList();
    ClassLoader myClassLoader;
    LoopbackChannel myLoopbackChannel = new LoopbackChannel(this);
    List<Channel> myChannelList = new LinkedList<Channel>();
    AcceptThread myAcceptThread;
    ConnectListener myConnectListener;

    public ChannelGroup() {
        this.myChannelList.add(this.myLoopbackChannel);
    }

    public ChannelGroup(InetSocketAddress inetSocketAddress) throws IOException {
        this();
        this.listen(inetSocketAddress);
    }

    public ChannelGroup(ServerSocketChannel serverSocketChannel) throws IOException {
        this();
        this.listen(serverSocketChannel);
    }

    public synchronized InetSocketAddress listenAddress() {
        return this.myServerSocketChannel == null ? null : (InetSocketAddress)this.myServerSocketChannel.socket().getLocalSocketAddress();
    }

    public synchronized void listen(InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(inetSocketAddress);
        this.listen(serverSocketChannel);
    }

    public synchronized void listen(ServerSocketChannel serverSocketChannel) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.listen(): Channel group closed");
        }
        if (serverSocketChannel != null) {
            if (!serverSocketChannel.socket().isBound()) {
                throw new IOException("ChannelGroup.listen(): Server socket channel is not bound");
            }
            this.stopListen();
            this.myServerSocketChannel = serverSocketChannel;
            this.myAcceptThread = new AcceptThread();
        } else {
            this.stopListen();
        }
    }

    public synchronized void stopListen() throws IOException {
        if (this.myServerSocketChannel != null) {
            this.myServerSocketChannel.close();
            this.myServerSocketChannel = null;
            this.myAcceptThread = null;
        }
    }

    public synchronized void setConnectListener(ConnectListener connectListener) {
        this.myConnectListener = connectListener;
    }

    public synchronized Channel connect(InetSocketAddress inetSocketAddress) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.connect(): Channel group closed");
        }
        return this.connect(SocketChannel.open(inetSocketAddress));
    }

    public synchronized Channel loopbackChannel() {
        return this.myLoopbackChannel;
    }

    public synchronized Channel channelTo(InetSocketAddress inetSocketAddress) {
        if (this.myChannelList != null) {
            for (Channel channel : this.myChannelList) {
                if (!channel.farEndAddress().equals(inetSocketAddress)) continue;
                return channel;
            }
        }
        return null;
    }

    public synchronized Channel channelToHost(InetAddress inetAddress) {
        if (this.myChannelList != null) {
            for (Channel channel : this.myChannelList) {
                if (!channel.farEndAddress().getAddress().equals(inetAddress)) continue;
                return channel;
            }
        }
        return null;
    }

    public synchronized Channel waitForChannelTo(InetSocketAddress inetSocketAddress) throws InterruptedException {
        Channel channel = null;
        if (this.myChannelList != null) {
            while (channel == null) {
                for (Channel channel2 : this.myChannelList) {
                    if (!channel2.farEndAddress().equals(inetSocketAddress)) continue;
                    channel = channel2;
                    break;
                }
                if (channel != null) continue;
                this.wait();
            }
        }
        return channel;
    }

    public synchronized Channel waitForChannelToHost(InetAddress inetAddress) throws InterruptedException {
        Channel channel = null;
        if (this.myChannelList != null) {
            while (channel == null) {
                for (Channel channel2 : this.myChannelList) {
                    if (!channel2.farEndAddress().getAddress().equals(inetAddress)) continue;
                    channel = channel2;
                    break;
                }
                if (channel != null) continue;
                this.wait();
            }
        }
        return channel;
    }

    public void send(Channel channel, Buf buf) throws IOException {
        this.sendNoWait(channel, 0, buf).waitForFinish();
    }

    public void send(Channel channel, int n, Buf buf) throws IOException {
        this.sendNoWait(channel, n, buf).waitForFinish();
    }

    public IORequest sendNoWait(Channel channel, Buf buf) throws IOException {
        return this.sendNoWait(channel, 0, buf);
    }

    public IORequest sendNoWait(Channel channel, int n, Buf buf) throws IOException {
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.sendNoWait(): Channel group closed");
        }
        if (channel == null) {
            throw new NullPointerException("ChannelGroup.sendNoWait(): Channel is null");
        }
        if (buf == null) {
            throw new NullPointerException("ChannelGroup.sendNoWait(): Item source buffer is null");
        }
        if (channel.myChannelGroup != this) {
            throw new IllegalArgumentException("ChannelGroup.sendNoWait(): Channel not created by this channel group");
        }
        IORequest iORequest = new IORequest(channel, n, buf);
        channel.send(iORequest);
        return iORequest;
    }

    public Status receive(Channel channel, Buf buf) throws IOException {
        return this.receiveNoWait(channel, 0, buf, null).waitForFinish();
    }

    public Status receive(Channel channel, Integer n, Buf buf) throws IOException {
        return this.receiveNoWait(channel, n, buf, null).waitForFinish();
    }

    public IORequest receiveNoWait(Channel channel, Buf buf) throws IOException {
        return this.receiveNoWait(channel, 0, buf, null);
    }

    public IORequest receiveNoWait(Channel channel, Integer n, Buf buf) throws IOException {
        return this.receiveNoWait(channel, n, buf, null);
    }

    public Status receive(Channel channel, Buf buf, IOCompletionHook iOCompletionHook) throws IOException {
        return this.receiveNoWait(channel, 0, buf, iOCompletionHook).waitForFinish();
    }

    public Status receive(Channel channel, Integer n, Buf buf, IOCompletionHook iOCompletionHook) throws IOException {
        return this.receiveNoWait(channel, n, buf, iOCompletionHook).waitForFinish();
    }

    public IORequest receiveNoWait(Channel channel, Buf buf, IOCompletionHook iOCompletionHook) throws IOException {
        return this.receiveNoWait(channel, 0, buf, iOCompletionHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IORequest receiveNoWait(Channel channel, Integer n, Buf buf, IOCompletionHook iOCompletionHook) throws IOException {
        Object object;
        if (this.myIORequestList == null) {
            throw new IOException("ChannelGroup.receiveNoWait(): Channel group closed");
        }
        if (buf == null) {
            throw new NullPointerException("ChannelGroup.receiveNoWait(): Item destination buffer is null");
        }
        if (channel != null) {
            if (channel.myChannelGroup != this) {
                throw new IllegalArgumentException("ChannelGroup.receiveNoWait(): Channel not created by this channel group");
            }
            object = channel;
            synchronized (object) {
                if (channel.myReadState == 1) {
                    throw new IOException("ChannelGroup.receiveNoWait(): Channel closed");
                }
            }
        }
        object = new IORequest(channel, n, buf, iOCompletionHook);
        this.myIORequestList.add((IORequest)object);
        return object;
    }

    public synchronized void setAlternateClassLoader(ClassLoader classLoader) {
        this.myClassLoader = classLoader;
    }

    public synchronized void close() {
        try {
            this.stopListen();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.myChannelList != null) {
            while (!this.myChannelList.isEmpty()) {
                this.myChannelList.get(0).close();
            }
        }
        if (this.myIORequestList != null) {
            this.myIORequestList.reportFailure(new ChannelGroupClosedException("Channel group closed"));
        }
        this.myServerSocketChannel = null;
        this.myIORequestList = null;
        this.myClassLoader = null;
        this.myLoopbackChannel = null;
        this.myChannelList = null;
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel connect(SocketChannel socketChannel) {
        NetworkChannel networkChannel = null;
        ChannelGroup channelGroup = this;
        synchronized (channelGroup) {
            if (this.myIORequestList != null) {
                try {
                    socketChannel.socket().setTcpNoDelay(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                networkChannel = new NetworkChannel(this, socketChannel);
                this.myChannelList.add(networkChannel);
                this.notifyAll();
            }
        }
        if (this.myConnectListener != null && networkChannel != null) {
            this.myConnectListener.connected(this, networkChannel);
        }
        return networkChannel;
    }

    synchronized void removeChannel(Channel channel) {
        if (this.myChannelList != null) {
            this.myChannelList.remove(channel);
        }
    }

    private class AcceptThread
    extends Thread {
        public AcceptThread() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    ChannelGroup.this.connect(ChannelGroup.this.myServerSocketChannel.accept());
                }
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException iOException) {
                System.err.println("edu.rit.mp.ChannelGroup: I/O error while accepting connection");
                iOException.printStackTrace(System.err);
            }
        }
    }
}

