/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import java.io.IOException;
import java.net.InetSocketAddress;

public abstract class Channel {
    ChannelGroup myChannelGroup;
    IORequestList myIORequestList;
    Object myInfo;
    int myWriteState = 0;
    static final int WRITE_OPEN = 0;
    static final int WRITE_CLOSED = 1;
    int myReadState = 0;
    static final int READ_OPEN = 0;
    static final int READ_CLOSED = 1;

    Channel(ChannelGroup channelGroup) {
        this.myChannelGroup = channelGroup;
        this.myIORequestList = channelGroup.myIORequestList;
    }

    public abstract InetSocketAddress nearEndAddress();

    public abstract InetSocketAddress farEndAddress();

    public Object info() {
        return this.myInfo;
    }

    public void info(Object object) {
        this.myInfo = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ChannelGroup channelGroup = this.myChannelGroup;
        synchronized (channelGroup) {
            Channel channel = this;
            synchronized (channel) {
                this.myChannelGroup.removeChannel(this);
                this.myWriteState = 1;
                this.myReadState = 1;
                this.subclassClose();
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public String toString() {
        return this.getClass().getName() + "(near=" + this.nearEndAddress() + ",far=" + this.farEndAddress() + ")";
    }

    abstract void send(IORequest var1) throws IOException;

    void subclassClose() {
    }
}

