/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.ByteArrayBuf;
import edu.rit.mp.buf.ByteArrayBuf_1;
import edu.rit.mp.buf.ByteItemBuf;
import edu.rit.mp.buf.ByteMatrixBuf;
import edu.rit.mp.buf.ByteMatrixBuf_1;
import edu.rit.mp.buf.SharedByteArrayBuf;
import edu.rit.mp.buf.SharedByteArrayBuf_1;
import edu.rit.mp.buf.SharedByteBuf;
import edu.rit.pj.reduction.SharedByte;
import edu.rit.pj.reduction.SharedByteArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class ByteBuf
extends Buf {
    protected ByteBuf(int n) {
        super((byte)1, n);
    }

    public static ByteItemBuf buffer() {
        return new ByteItemBuf();
    }

    public static ByteItemBuf buffer(byte by) {
        return new ByteItemBuf(by);
    }

    public static ByteBuf buffer(byte[] byArray) {
        return new ByteArrayBuf_1(byArray, new Range(0, byArray.length - 1));
    }

    public static ByteBuf sliceBuffer(byte[] byArray, Range range) {
        if (range.stride() == 1) {
            return new ByteArrayBuf_1(byArray, range);
        }
        return new ByteArrayBuf(byArray, range);
    }

    public static ByteBuf[] sliceBuffers(byte[] byArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ByteBuf[] byteBufArray = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            byteBufArray[i] = ByteBuf.sliceBuffer(byArray, rangeArray[i]);
        }
        return byteBufArray;
    }

    public static ByteBuf buffer(byte[][] byArray) {
        return new ByteMatrixBuf_1(byArray, new Range(0, byArray.length - 1), new Range(0, byArray[0].length - 1));
    }

    public static ByteBuf rowSliceBuffer(byte[][] byArray, Range range) {
        if (range.stride() == 1) {
            return new ByteMatrixBuf_1(byArray, range, new Range(0, byArray[0].length - 1));
        }
        return new ByteMatrixBuf(byArray, range, new Range(0, byArray[0].length - 1));
    }

    public static ByteBuf[] rowSliceBuffers(byte[][] byArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ByteBuf[] byteBufArray = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            byteBufArray[i] = ByteBuf.rowSliceBuffer(byArray, rangeArray[i]);
        }
        return byteBufArray;
    }

    public static ByteBuf colSliceBuffer(byte[][] byArray, Range range) {
        if (range.stride() == 1) {
            return new ByteMatrixBuf_1(byArray, new Range(0, byArray.length - 1), range);
        }
        return new ByteMatrixBuf(byArray, new Range(0, byArray.length - 1), range);
    }

    public static ByteBuf[] colSliceBuffers(byte[][] byArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ByteBuf[] byteBufArray = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            byteBufArray[i] = ByteBuf.colSliceBuffer(byArray, rangeArray[i]);
        }
        return byteBufArray;
    }

    public static ByteBuf patchBuffer(byte[][] byArray, Range range, Range range2) {
        if (range.stride() == 1 && range2.stride() == 1) {
            return new ByteMatrixBuf_1(byArray, range, range2);
        }
        return new ByteMatrixBuf(byArray, range, range2);
    }

    public static ByteBuf[] patchBuffers(byte[][] byArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        ByteBuf[] byteBufArray = new ByteBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                byteBufArray[n3++] = ByteBuf.patchBuffer(byArray, range, rangeArray2[j]);
            }
        }
        return byteBufArray;
    }

    public static ByteBuf buffer(SharedByte sharedByte) {
        return new SharedByteBuf(sharedByte);
    }

    public static ByteBuf buffer(SharedByteArray sharedByteArray) {
        return new SharedByteArrayBuf_1(sharedByteArray, new Range(0, sharedByteArray.length() - 1));
    }

    public static ByteBuf sliceBuffer(SharedByteArray sharedByteArray, Range range) {
        if (range.stride() == 1) {
            return new SharedByteArrayBuf_1(sharedByteArray, range);
        }
        return new SharedByteArrayBuf(sharedByteArray, range);
    }

    public static ByteBuf[] sliceBuffers(SharedByteArray sharedByteArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ByteBuf[] byteBufArray = new ByteBuf[n];
        for (int i = 0; i < n; ++i) {
            byteBufArray[i] = ByteBuf.sliceBuffer(sharedByteArray, rangeArray[i]);
        }
        return byteBufArray;
    }

    public abstract byte get(int var1);

    public abstract void put(int var1, byte var2);

    public void copy(Buf buf) {
        if (buf != this) {
            ByteBuf.defaultCopy((ByteBuf)buf, this);
        }
    }

    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining());
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    protected static void defaultCopy(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n = Math.min(byteBuf.myLength, byteBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            byteBuf2.put(i, byteBuf.get(i));
        }
    }
}

