/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.DataBufferIntegerMatrix;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

class SampleModelIntegerMatrix
extends SampleModel {
    private static final int[] shift = new int[]{16, 8, 0};
    private static final int[] mask = new int[]{-16711681, -65281, -256};

    public SampleModelIntegerMatrix(int n, int n2) {
        super(3, n, n2, 3);
    }

    public int getNumDataElements() {
        return 1;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int[] nArray = (int[])object;
        if (nArray == null) {
            nArray = new int[1];
        }
        int[][] nArray2 = ((DataBufferIntegerMatrix)dataBuffer).myMatrix;
        nArray[0] = nArray2[n2][n];
        return nArray;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int[] nArray = (int[])object;
        int[][] nArray2 = ((DataBufferIntegerMatrix)dataBuffer).myMatrix;
        nArray2[n2][n] = nArray[0];
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int[][] nArray = ((DataBufferIntegerMatrix)dataBuffer).myMatrix;
        int n4 = nArray[n2][n];
        return n4 >> shift[n3] & 0xFF;
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int[][] nArray = ((DataBufferIntegerMatrix)dataBuffer).myMatrix;
        int n5 = nArray[n2][n];
        nArray[n2][n] = n5 = n5 & mask[n3] | (n4 & 0xFF) << shift[n3];
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SampleModelIntegerMatrix(n, n2);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        return new SampleModelIntegerMatrix(this.getWidth(), this.getHeight());
    }

    public DataBuffer createDataBuffer() {
        int[][] nArray = new int[this.getHeight()][this.getWidth()];
        return new DataBufferIntegerMatrix(nArray);
    }

    public int[] getSampleSize() {
        return new int[]{8, 8, 8};
    }

    public int getSampleSize(int n) {
        return 8;
    }
}

