/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.color.HSB;
import edu.rit.color.IntRGB;
import edu.rit.color.RGB;
import java.awt.Color;
import java.awt.image.IndexColorModel;

public class IndexColorMap {
    byte[] myRed = new byte[256];
    byte[] myGreen = new byte[256];
    byte[] myBlue = new byte[256];

    public void setColor(int n, RGB rGB) {
        this.setColor(n, rGB.pack());
    }

    public void setColor(int n, IntRGB intRGB) {
        this.setColor(n, intRGB.pack());
    }

    public void setColor(int n, HSB hSB) {
        this.setColor(n, hSB.pack());
    }

    public void setColor(int n, Color color) {
        this.setColor(n, color.getRGB());
    }

    public void setColor(int n, float f, float f2, float f3) {
        this.setColor(n, RGB.pack(f, f2, f3));
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.setColor(n, IntRGB.pack(n2, n3, n4));
    }

    public void setColorHSB(int n, float f, float f2, float f3) {
        this.setColor(n, HSB.pack(f, f2, f3));
    }

    private void setColor(int n, int n2) {
        this.myRed[n] = (byte)(n2 >> 16 & 0xFF);
        this.myGreen[n] = (byte)(n2 >> 8 & 0xFF);
        this.myBlue[n] = (byte)(n2 & 0xFF);
    }

    IndexColorModel getIndexColorModel() {
        return new IndexColorModel(8, 256, this.myRed, this.myGreen, this.myBlue);
    }
}

