/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.DataBufferByteMatrix;
import edu.rit.image.IndexColorMap;
import edu.rit.image.SampleModelByteMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class IndexColorImage
extends BufferedImage {
    byte[][] myMatrix;

    public IndexColorImage(byte[][] byArray, IndexColorMap indexColorMap) {
        this(byArray, indexColorMap, IndexColorImage.makeRaster(byArray));
    }

    IndexColorImage(byte[][] byArray, IndexColorMap indexColorMap, WritableRaster writableRaster) {
        super(indexColorMap.getIndexColorModel(), writableRaster, false, null);
        this.myMatrix = byArray;
    }

    private static WritableRaster makeRaster(byte[][] byArray) {
        int n = DataBufferByteMatrix.width(byArray);
        int n2 = DataBufferByteMatrix.height(byArray);
        return Raster.createWritableRaster(new SampleModelByteMatrix(n, n2), new DataBufferByteMatrix(byArray), null);
    }

    public byte[][] matrix() {
        return this.myMatrix;
    }

    public int getPixel(int n, int n2) {
        return this.myMatrix[n][n2] & 0xFF;
    }

    public void setPixel(int n, int n2, int n3) {
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        this.myMatrix[n][n2] = (byte)n3;
    }

    public void fill(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], (byte)n);
        }
    }
}

