/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.GrayImage;
import java.util.Arrays;

public class GrayImageRow {
    public static final GrayImage.Interpretation ZERO_IS_WHITE = GrayImage.Interpretation.ZERO_IS_WHITE;
    public static final GrayImage.Interpretation ZERO_IS_BLACK = GrayImage.Interpretation.ZERO_IS_BLACK;
    byte[][] myMatrix;
    GrayImage.Interpretation myInterpretation;
    byte[] myArray;

    public GrayImageRow(byte[][] byArray) {
        this(byArray, ZERO_IS_BLACK);
    }

    public GrayImageRow(byte[][] byArray, GrayImage.Interpretation interpretation) {
        this.myMatrix = byArray;
        this.myInterpretation = interpretation;
    }

    public byte[][] matrix() {
        return this.myMatrix;
    }

    public void row(int n) {
        this.myArray = this.myMatrix[n];
    }

    public int getIntPixel(int n) {
        int n2 = this.myArray[n] & 0xFF;
        if (this.myInterpretation == ZERO_IS_WHITE) {
            n2 = 255 - n2;
        }
        return n2;
    }

    public float getPixel(int n) {
        return (float)this.getIntPixel(n) / 256.0f;
    }

    public void setIntPixel(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (this.myInterpretation == ZERO_IS_WHITE) {
            n2 = 255 - n2;
        }
        this.myArray[n] = (byte)n2;
    }

    public void setPixel(int n, float f) {
        this.setIntPixel(n, (int)(f * 256.0f));
    }

    public void fill(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        if (this.myInterpretation == ZERO_IS_WHITE) {
            n = 255 - n;
        }
        Arrays.fill(this.myArray, (byte)n);
    }

    public void fill(float f) {
        this.fill(f * 256.0f);
    }
}

