/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.ByteGrayColorModel;
import edu.rit.image.DataBufferByteMatrix;
import edu.rit.image.SampleModelByteMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class GrayImage
extends BufferedImage {
    public static final Interpretation ZERO_IS_WHITE = Interpretation.ZERO_IS_WHITE;
    public static final Interpretation ZERO_IS_BLACK = Interpretation.ZERO_IS_BLACK;
    byte[][] myMatrix;
    Interpretation myInterpretation;

    public GrayImage(byte[][] byArray) {
        this(byArray, ZERO_IS_BLACK);
    }

    public GrayImage(byte[][] byArray, Interpretation interpretation) {
        this(byArray, interpretation, new ByteGrayColorModel(), GrayImage.makeRaster(byArray));
    }

    GrayImage(byte[][] byArray, Interpretation interpretation, ColorModel colorModel, WritableRaster writableRaster) {
        super(colorModel, writableRaster, false, null);
        this.myMatrix = byArray;
        this.myInterpretation = interpretation;
    }

    private static WritableRaster makeRaster(byte[][] byArray) {
        int n = DataBufferByteMatrix.width(byArray);
        int n2 = DataBufferByteMatrix.height(byArray);
        return Raster.createWritableRaster(new SampleModelByteMatrix(n, n2), new DataBufferByteMatrix(byArray), null);
    }

    public byte[][] matrix() {
        return this.myMatrix;
    }

    public int getIntPixel(int n, int n2) {
        int n3 = this.myMatrix[n][n2] & 0xFF;
        if (this.myInterpretation == ZERO_IS_WHITE) {
            n3 = 255 - n3;
        }
        return n3;
    }

    public float getPixel(int n, int n2) {
        return (float)this.getIntPixel(n, n2) / 256.0f;
    }

    public void setIntPixel(int n, int n2, int n3) {
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (this.myInterpretation == ZERO_IS_WHITE) {
            n3 = 255 - n3;
        }
        this.myMatrix[n][n2] = (byte)n3;
    }

    public void setPixel(int n, int n2, float f) {
        this.setIntPixel(n, n2, (int)(f * 256.0f));
    }

    public void fill(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        if (this.myInterpretation == ZERO_IS_WHITE) {
            n = 255 - n;
        }
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], (byte)n);
        }
    }

    public void fill(float f) {
        this.fill((int)(f * 256.0f));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpretation {
        ZERO_IS_WHITE,
        ZERO_IS_BLACK;

    }
}

