/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.color.HSB;
import edu.rit.color.IntRGB;
import edu.rit.color.RGB;
import java.awt.Color;
import java.util.Arrays;

public class ColorImageRow {
    int[][] myMatrix;
    int[] myArray;

    public ColorImageRow(int[][] nArray) {
        this.myMatrix = nArray;
    }

    public int[][] matrix() {
        return this.myMatrix;
    }

    public void row(int n) {
        this.myArray = this.myMatrix[n];
    }

    public void getPixel(int n, RGB rGB) {
        rGB.unpack(this.myArray[n]);
    }

    public void getPixel(int n, IntRGB intRGB) {
        intRGB.unpack(this.myArray[n]);
    }

    public void getPixel(int n, HSB hSB) {
        hSB.unpack(this.myArray[n]);
    }

    public Color getPixelColor(int n) {
        return new Color(this.myArray[n] & 0xFFFFFF);
    }

    public void setPixel(int n, RGB rGB) {
        this.myArray[n] = rGB.pack();
    }

    public void setPixel(int n, IntRGB intRGB) {
        this.myArray[n] = intRGB.pack();
    }

    public void setPixel(int n, HSB hSB) {
        this.myArray[n] = hSB.pack();
    }

    public void setPixelColor(int n, Color color) {
        this.myArray[n] = color.getRGB();
    }

    public void setPixel(int n, float f, float f2, float f3) {
        this.myArray[n] = RGB.pack(f, f2, f3);
    }

    public void setPixel(int n, int n2, int n3, int n4) {
        this.myArray[n] = IntRGB.pack(n2, n3, n4);
    }

    public void setPixelHSB(int n, float f, float f2, float f3) {
        this.myArray[n] = HSB.pack(f, f2, f3);
    }

    public void fill(RGB rGB) {
        Arrays.fill(this.myArray, rGB.pack());
    }

    public void fill(IntRGB intRGB) {
        Arrays.fill(this.myArray, intRGB.pack());
    }

    public void fill(HSB hSB) {
        Arrays.fill(this.myArray, hSB.pack());
    }

    public void fill(Color color) {
        Arrays.fill(this.myArray, color.getRGB());
    }

    public void fill(float f, float f2, float f3) {
        Arrays.fill(this.myArray, RGB.pack(f, f2, f3));
    }

    public void fill(int n, int n2, int n3) {
        Arrays.fill(this.myArray, IntRGB.pack(n, n2, n3));
    }

    public void fillHSB(float f, float f2, float f3) {
        Arrays.fill(this.myArray, HSB.pack(f, f2, f3));
    }
}

