/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.color.HSB;
import edu.rit.color.IntRGB;
import edu.rit.color.RGB;
import edu.rit.image.DataBufferIntegerMatrix;
import edu.rit.image.IntegerColorModel;
import edu.rit.image.SampleModelIntegerMatrix;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ColorImage
extends BufferedImage {
    int[][] myMatrix;

    public ColorImage(int[][] nArray) {
        this(nArray, new IntegerColorModel(), ColorImage.makeRaster(nArray));
    }

    ColorImage(int[][] nArray, ColorModel colorModel, WritableRaster writableRaster) {
        super(colorModel, writableRaster, false, null);
        this.myMatrix = nArray;
    }

    private static WritableRaster makeRaster(int[][] nArray) {
        int n = DataBufferIntegerMatrix.width(nArray);
        int n2 = DataBufferIntegerMatrix.height(nArray);
        return Raster.createWritableRaster(new SampleModelIntegerMatrix(n, n2), new DataBufferIntegerMatrix(nArray), null);
    }

    public int[][] matrix() {
        return this.myMatrix;
    }

    public void getPixel(int n, int n2, RGB rGB) {
        rGB.unpack(this.myMatrix[n][n2]);
    }

    public void getPixel(int n, int n2, IntRGB intRGB) {
        intRGB.unpack(this.myMatrix[n][n2]);
    }

    public void getPixel(int n, int n2, HSB hSB) {
        hSB.unpack(this.myMatrix[n][n2]);
    }

    public Color getPixelColor(int n, int n2) {
        return new Color(this.myMatrix[n][n2] & 0xFFFFFF);
    }

    public void setPixel(int n, int n2, RGB rGB) {
        this.myMatrix[n][n2] = rGB.pack();
    }

    public void setPixel(int n, int n2, IntRGB intRGB) {
        this.myMatrix[n][n2] = intRGB.pack();
    }

    public void setPixel(int n, int n2, HSB hSB) {
        this.myMatrix[n][n2] = hSB.pack();
    }

    public void setPixelColor(int n, int n2, Color color) {
        this.myMatrix[n][n2] = color.getRGB();
    }

    public void setPixel(int n, int n2, float f, float f2, float f3) {
        this.myMatrix[n][n2] = RGB.pack(f, f2, f3);
    }

    public void setPixel(int n, int n2, int n3, int n4, int n5) {
        this.myMatrix[n][n2] = IntRGB.pack(n3, n4, n5);
    }

    public void setPixelHSB(int n, int n2, float f, float f2, float f3) {
        this.myMatrix[n][n2] = HSB.pack(f, f2, f3);
    }

    public void fill(RGB rGB) {
        int n = rGB.pack();
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], n);
        }
    }

    public void fill(IntRGB intRGB) {
        int n = intRGB.pack();
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], n);
        }
    }

    public void fill(HSB hSB) {
        int n = hSB.pack();
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], n);
        }
    }

    public void fill(Color color) {
        int n = color.getRGB();
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], n);
        }
    }

    public void fill(float f, float f2, float f3) {
        int n = RGB.pack(f, f2, f3);
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], n);
        }
    }

    public void fill(int n, int n2, int n3) {
        int n4 = IntRGB.pack(n, n2, n3);
        int n5 = this.myMatrix.length;
        for (int i = 0; i < n5; ++i) {
            Arrays.fill(this.myMatrix[i], n4);
        }
    }

    public void fillHSB(float f, float f2, float f3) {
        int n = HSB.pack(f, f2, f3);
        int n2 = this.myMatrix.length;
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.myMatrix[i], n);
        }
    }
}

