/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.prime;

import edu.rit.pj.Comm;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class Prime32Seq {
    static File file;
    static long n;
    static long upperbound;
    static long[] primeList;
    static long[] primeSquareList;
    static int primeCount;
    static BufferedOutputStream out;
    static int totalPrimeCount;

    private Prime32Seq() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        long l = -System.currentTimeMillis();
        if (stringArray.length != 2) {
            Prime32Seq.usage();
        }
        file = new File(stringArray[0]);
        try {
            Prime32Seq.n = Long.parseLong(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            Prime32Seq.usage();
        }
        if (16L > Prime32Seq.n || Prime32Seq.n > 32L) {
            Prime32Seq.usage();
        }
        upperbound = 1L << (int)Prime32Seq.n;
        out = new BufferedOutputStream(new FileOutputStream(file));
        out.write(2);
        ++totalPrimeCount;
        primeCount = 0;
        for (long i = 3L; i < 65536L; i += 2L) {
            n = 1;
            for (int j = 0; n != 0 && j < primeCount && primeSquareList[j] <= i; ++j) {
                n = i % primeList[j] != 0L ? 1 : 0;
            }
            if (n == 0) continue;
            Prime32Seq.primeList[Prime32Seq.primeCount] = i;
            Prime32Seq.primeSquareList[Prime32Seq.primeCount] = i * i;
            ++primeCount;
        }
        boolean[] blArray = new boolean[65536];
        byte[] byArray = new byte[65536];
        for (long i = 0L; i < upperbound; i += 65536L) {
            int n2;
            for (n2 = 1; n2 < 65536; n2 += 2) {
                long l2 = i + (long)n2;
                boolean bl = l2 > 1L;
                for (int j = 0; bl && j < primeCount && primeSquareList[j] <= l2; ++j) {
                    bl = l2 % primeList[j] != 0L;
                }
                blArray[n2] = bl;
            }
            n = 0;
            for (n2 = 0; n2 < 65536; n2 += 256) {
                int n3 = n2 + 256;
                for (int j = n2 + 1; j < n3; j += 2) {
                    if (!blArray[j]) continue;
                    byArray[n++] = (byte)j;
                    ++totalPrimeCount;
                }
                byArray[n++] = 0;
            }
            out.write(byArray, 0, n);
        }
        out.close();
        System.out.println(totalPrimeCount + " primes");
        System.out.println((l += System.currentTimeMillis()) + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.hyb.prime.Prime32Seq <file> <n>");
        System.err.println("<file> = Output file name");
        System.err.println("Will list primes up to 2^n, 16 <= n <= 32");
        System.exit(1);
    }

    static {
        primeList = new long[6541];
        primeSquareList = new long[6541];
    }
}

