/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.prime;

import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.IntegerStrideForLoop;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.LongStrideForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class Prime32Hyb {
    static Comm world;
    static int size;
    static int rank;
    static File file;
    static long n;
    static long upperbound;
    static long[] primeList;
    static long[] primeSquareList;
    static int primeCount;
    static BufferedOutputStream out;
    static int totalPrimeCount;
    static ParallelSection masterSection;
    static ParallelSection workerSection;

    private Prime32Hyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            Prime32Hyb.usage();
        }
        file = new File(stringArray[0]);
        try {
            n = Long.parseLong(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            Prime32Hyb.usage();
        }
        if (16L > n || n > 32L) {
            Prime32Hyb.usage();
        }
        upperbound = 1L << (int)n;
        primeCount = 0;
        for (long i = 3L; i < 65536L; i += 2L) {
            boolean bl = true;
            for (int j = 0; bl && j < primeCount && primeSquareList[j] <= i; ++j) {
                bl = i % primeList[j] != 0L;
            }
            if (!bl) continue;
            Prime32Hyb.primeList[Prime32Hyb.primeCount] = i;
            Prime32Hyb.primeSquareList[Prime32Hyb.primeCount] = i * i;
            ++primeCount;
        }
        if (rank == 0) {
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(2);
            new ParallelTeam(2).execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(masterSection, workerSection);
                }
            });
            out.close();
            IntegerItemBuf integerItemBuf = new IntegerItemBuf(++totalPrimeCount);
            world.reduce(0, integerItemBuf, IntegerOp.SUM);
            totalPrimeCount = integerItemBuf.item;
            System.out.println(totalPrimeCount + " primes");
        } else {
            workerSection.run();
            IntegerItemBuf integerItemBuf = new IntegerItemBuf(totalPrimeCount);
            world.reduce(0, integerItemBuf, IntegerOp.SUM);
        }
        System.out.println((l += System.currentTimeMillis()) + " msec " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> edu.rit.hyb.prime.Prime32Hyb <file> <n>");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<file> = Output file name");
        System.err.println("Will list primes up to 2^n, 16 <= n <= 32");
        System.exit(1);
    }

    static {
        primeList = new long[6541];
        primeSquareList = new long[6541];
        masterSection = new ParallelSection(){

            public void run() throws Exception {
                new ParallelTeam(size).execute(new ParallelRegion(){

                    public void run() throws Exception {
                        this.execute(0L, upperbound - 1L, 65536L, NO_WAIT, new LongStrideForLoop(){
                            int worker;
                            LongItemBuf xUpperBuf;
                            byte[] primeBlock;
                            ByteBuf primeBlockBuf;
                            CommStatus status;

                            public void start() {
                                this.worker = this.getThreadIndex();
                                this.xUpperBuf = new LongItemBuf();
                                this.primeBlock = new byte[65536];
                                this.primeBlockBuf = ByteBuf.buffer(this.primeBlock);
                            }

                            public LongSchedule schedule() {
                                return LongSchedule.dynamic();
                            }

                            public void run(long l, long l2, long l3) throws Exception {
                                this.xUpperBuf.item = l;
                                world.send(this.worker, this.xUpperBuf);
                                this.status = world.receive(this.worker, this.primeBlockBuf);
                                this.ordered(new ParallelSection(){

                                    public void run() throws Exception {
                                        out.write(primeBlock, 0, status.length);
                                    }
                                });
                            }

                            public void finish() throws Exception {
                                this.xUpperBuf.item = -1L;
                                world.send(this.worker, this.xUpperBuf);
                            }
                        });
                    }
                });
            }
        };
        workerSection = new ParallelSection(){
            long xUpper;
            LongItemBuf xUpperBuf = new LongItemBuf();
            boolean[] xIsPrime = new boolean[65536];
            byte[] primeBlock = new byte[65536];
            int blockCount;
            ByteBuf primeBlockBuf;
            ParallelTeam team = new ParallelTeam();

            public void run() throws Exception {
                while (true) {
                    world.receive(0, this.xUpperBuf);
                    this.xUpper = this.xUpperBuf.item;
                    if (this.xUpper == -1L) break;
                    this.team.execute(new ParallelRegion(){

                        public void run() throws Exception {
                            this.execute(1, 65535, 2, NO_WAIT, new IntegerStrideForLoop(){

                                public IntegerSchedule schedule() {
                                    return IntegerSchedule.guided();
                                }

                                public void run(int n, int n2, int n3) {
                                    for (int i = n; i <= n2; i += 2) {
                                        long l = xUpper + (long)i;
                                        boolean bl = l > 1L;
                                        for (int j = 0; bl && j < primeCount && primeSquareList[j] <= l; ++j) {
                                            bl = l % primeList[j] != 0L;
                                        }
                                        xIsPrime[i] = bl;
                                    }
                                }
                            });
                        }
                    });
                    this.blockCount = 0;
                    for (int i = 0; i < 65536; i += 256) {
                        int n = i + 256;
                        for (int j = i + 1; j < n; j += 2) {
                            if (!this.xIsPrime[j]) continue;
                            this.primeBlock[this.blockCount++] = (byte)j;
                            ++totalPrimeCount;
                        }
                        this.primeBlock[this.blockCount++] = 0;
                    }
                    this.primeBlockBuf = ByteBuf.sliceBuffer(this.primeBlock, new Range(0, this.blockCount - 1));
                    world.send(0, this.primeBlockBuf);
                }
            }
        };
    }
}

