/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.network;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;

public class FloydHyb {
    static Comm world;
    static int size;
    static int rank;
    static int n;
    static double[][] d;
    static Range[] ranges;
    static Range myrange;
    static int mylb;
    static int myub;
    static DoubleBuf[] slices;
    static DoubleBuf myslice;

    private FloydHyb() {
    }

    public static void main(String[] stringArray) throws Throwable {
        Object object;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            FloydHyb.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (rank == 0) {
            object = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            n = ((DataInputStream)object).readInt();
            d = new double[n][n];
            for (int i = 0; i < n; ++i) {
                double[] dArray = d[i];
                for (int j = 0; j < n; ++j) {
                    dArray[j] = ((DataInputStream)object).readDouble();
                }
            }
            ((FilterInputStream)object).close();
        }
        object = new IntegerItemBuf(n);
        world.broadcast(0, (Buf)object);
        n = ((IntegerItemBuf)object).item;
        if (rank != 0) {
            d = new double[n][n];
        }
        ranges = new Range(0, n - 1).subranges(size);
        myrange = ranges[rank];
        mylb = myrange.lb();
        myub = myrange.ub();
        slices = DoubleBuf.rowSliceBuffers(d, ranges);
        myslice = slices[rank];
        long l2 = System.currentTimeMillis();
        world.scatter(0, slices, myslice);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                int n = 0;
                for (int i = 0; i < FloydHyb.n; ++i) {
                    final int n2 = i;
                    final double[] dArray = d[n2];
                    if (this.getThreadIndex() == 0) {
                        if (!ranges[n].contains(n2)) {
                            ++n;
                        }
                        world.broadcast(n, DoubleBuf.buffer(dArray));
                    }
                    this.barrier();
                    this.execute(mylb, myub, new IntegerForLoop(){

                        public void run(int n, int n22) {
                            for (int i = n; i <= n22; ++i) {
                                double[] dArray2 = d[i];
                                for (int j = 0; j < FloydHyb.n; ++j) {
                                    dArray2[j] = Math.min(dArray2[j], dArray2[n2] + dArray[j]);
                                }
                            }
                        }
                    });
                }
            }
        });
        world.gather(0, myslice, slices);
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                double[] dArray = d[i];
                for (int j = 0; j < n; ++j) {
                    dataOutputStream.writeDouble(dArray[j]);
                }
            }
            dataOutputStream.close();
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.hyb.network.FloydHyb <infile> <outfile>");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

