/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.keysearch;

import edu.rit.crypto.blockcipher.AES256CipherSmp;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Hex;
import edu.rit.util.Range;

public class FindKeyHyb {
    static Comm world;
    static int size;
    static int rank;
    static byte[] plaintext;
    static byte[] ciphertext;
    static byte[] partialkey;
    static int n;
    static int keylsbs;
    static int maxcounter;
    static byte[] foundkey;
    static Range chunk;

    private FindKeyHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 4) {
            FindKeyHyb.usage();
        }
        plaintext = Hex.toByteArray(stringArray[0]);
        ciphertext = Hex.toByteArray(stringArray[1]);
        partialkey = Hex.toByteArray(stringArray[2]);
        n = Integer.parseInt(stringArray[3]);
        if (n < 0) {
            System.err.println("n = " + n + " is too small");
            System.exit(1);
        }
        if (n > 30) {
            System.err.println("n = " + n + " is too large");
            System.exit(1);
        }
        keylsbs = (partialkey[28] & 0xFF) << 24 | (partialkey[29] & 0xFF) << 16 | (partialkey[30] & 0xFF) << 8 | partialkey[31] & 0xFF;
        maxcounter = (1 << n) - 1;
        chunk = new Range(0, maxcounter).subrange(size, rank);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(chunk.lb(), chunk.ub(), new IntegerForLoop(){
                    byte[] trialkey;
                    byte[] trialciphertext;
                    AES256CipherSmp cipher;

                    public void start() {
                        this.trialkey = new byte[96];
                        System.arraycopy(partialkey, 0, this.trialkey, 0, 32);
                        this.trialciphertext = new byte[80];
                        this.cipher = new AES256CipherSmp(this.trialkey);
                    }

                    public void run(int n, int n2) {
                        for (int i = n; i <= n2; ++i) {
                            int n3 = keylsbs | i;
                            this.trialkey[28] = (byte)(n3 >>> 24);
                            this.trialkey[29] = (byte)(n3 >>> 16);
                            this.trialkey[30] = (byte)(n3 >>> 8);
                            this.trialkey[31] = (byte)n3;
                            this.cipher.setKey(this.trialkey);
                            this.cipher.encrypt(plaintext, this.trialciphertext);
                            if (!FindKeyHyb.match(ciphertext, this.trialciphertext)) continue;
                            foundkey = new byte[32];
                            System.arraycopy(this.trialkey, 0, foundkey, 0, 32);
                        }
                    }
                });
            }
        });
        if (foundkey != null) {
            System.out.println(Hex.toString(foundkey));
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec (" + rank + ")");
    }

    private static boolean match(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            bl = bl && byArray[i] == byArray2[i];
        }
        return bl;
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.hyb.keysearch.FindKeyHyb <plaintext> <ciphertext> <partialkey> <n>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<plaintext> = Plaintext (128-bit hexadecimal number)");
        System.err.println("<ciphertext> = Ciphertext (128-bit hexadecimal number)");
        System.err.println("<partialkey> = Partial key (256-bit hexadecimal number)");
        System.err.println("<n> = Number of key bits to search for");
        System.exit(1);
    }
}

