/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.fractal;

import edu.rit.color.HSB;
import edu.rit.image.ColorImage;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class MandelbrotSetHyb {
    static Comm world;
    static int size;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static IntegerSchedule prsch;
    static IntegerSchedule thsch;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static ColorImage image;
    static int[] huetable;
    static ParallelSection masterSection;
    static ParallelSection workerSection;

    private MandelbrotSetHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (8 > stringArray.length || stringArray.length > 10) {
            MandelbrotSetHyb.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        prsch = stringArray.length >= 9 ? IntegerSchedule.parse(stringArray[8]) : IntegerSchedule.fixed();
        thsch = stringArray.length >= 10 ? IntegerSchedule.parse(stringArray[9]) : IntegerSchedule.fixed();
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        if (rank == 0) {
            matrix = new int[height][width];
            image = new ColorImage(matrix);
        }
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetHyb.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetHyb.huetable[MandelbrotSetHyb.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        masterSection = new ParallelSection(){

            public void run() throws Exception {
                new ParallelTeam(size).execute(new ParallelRegion(){

                    public void run() throws Exception {
                        this.execute(0, height - 1, NO_WAIT, new IntegerForLoop(){
                            int worker;
                            Range range;
                            ObjectItemBuf<Range> rangebuf;

                            public IntegerSchedule schedule() {
                                return prsch;
                            }

                            public void start() {
                                this.worker = this.getThreadIndex();
                                this.rangebuf = new ObjectItemBuf();
                            }

                            public void run(int n, int n2) throws Exception {
                                this.range = new Range(n, n2);
                                this.rangebuf.item = this.range;
                                world.send(this.worker, this.rangebuf);
                                IntegerBuf integerBuf = IntegerBuf.rowSliceBuffer(matrix, this.range);
                                world.receive(this.worker, integerBuf);
                            }

                            public void finish() throws Exception {
                                this.rangebuf.item = null;
                                world.send(this.worker, this.rangebuf);
                            }
                        });
                    }
                });
            }
        };
        workerSection = new ParallelSection(){
            Range range = null;
            ObjectItemBuf<Range> rangebuf = new ObjectItemBuf();
            int mylb;
            int myub;
            int[][] matrix = null;
            IntegerBuf slicebuf = null;
            ParallelTeam team = new ParallelTeam();

            public void run() throws Exception {
                while (true) {
                    world.receive(0, this.rangebuf);
                    this.range = (Range)this.rangebuf.item;
                    if (this.range == null) break;
                    if (this.matrix == null || this.matrix.length < this.range.length()) {
                        this.matrix = new int[this.range.length()][width];
                    }
                    this.slicebuf = IntegerBuf.rowSliceBuffer(this.matrix, new Range(0, this.range.length() - 1));
                    this.mylb = this.range.lb();
                    this.myub = this.range.ub();
                    this.team.execute(new ParallelRegion(){

                        public void run() throws Exception {
                            this.execute(mylb, myub, new IntegerForLoop(){

                                public IntegerSchedule schedule() {
                                    return thsch;
                                }

                                public void run(int n, int n2) {
                                    for (int i = n; i <= n2; ++i) {
                                        double d = ycenter + (double)(yoffset - i) / resolution;
                                        for (int j = 0; j < width; ++j) {
                                            int n3;
                                            double d2 = xcenter + (double)(xoffset + j) / resolution;
                                            double d3 = 0.0;
                                            double d4 = 0.0;
                                            double d5 = 0.0;
                                            double d6 = 0.0;
                                            double d7 = 0.0;
                                            for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                                d5 = d3 * d3 - d4 * d4 + d2;
                                                d6 = 2.0 * d3 * d4 + d;
                                                d7 = d5 * d5 + d6 * d6;
                                                d3 = d5;
                                                d4 = d6;
                                            }
                                            matrix[i - mylb][j] = huetable[n3];
                                        }
                                    }
                                }
                            });
                        }
                    });
                    world.send(0, this.slicebuf);
                }
            }
        };
        long l2 = System.currentTimeMillis();
        if (rank == 0) {
            new ParallelTeam(2).execute(new ParallelRegion(){

                public void run() throws Exception {
                    this.execute(masterSection, workerSection);
                }
            });
        } else {
            workerSection.run();
        }
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename)));
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: -Dpj.np=<Kp> -Dpj.nt=<Kt> java edu.rit.hyb.fractal.MandelbrotSetHyb <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename> [<prsch> [<thsch>]]");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PNG image file name");
        System.err.println("<prsch> = Schedule for dividing image among processes (default fixed)");
        System.err.println("<thsch> = Schedule for dividing image among threads (default fixed)");
        System.exit(1);
    }
}

