/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.http;

import edu.rit.http.HttpRequest;
import edu.rit.http.HttpResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class HttpServer {
    private ServerSocket myServerSocket = new ServerSocket();
    private AcceptorThread myAcceptorThread;

    public HttpServer(InetSocketAddress inetSocketAddress) throws IOException {
        this.myServerSocket.bind(inetSocketAddress);
        this.myAcceptorThread = new AcceptorThread();
        this.myAcceptorThread.setDaemon(true);
        this.myAcceptorThread.start();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.myServerSocket.getLocalSocketAddress();
    }

    public void close() throws IOException {
        this.myServerSocket.close();
    }

    protected abstract void process(HttpRequest var1, HttpResponse var2) throws IOException;

    private class AcceptorThread
    extends Thread {
        private AcceptorThread() {
        }

        public void run() {
            try {
                while (true) {
                    Socket socket = HttpServer.this.myServerSocket.accept();
                    HttpRequest httpRequest = new HttpRequest(socket);
                    HttpResponse httpResponse = new HttpResponse(socket);
                    try {
                        HttpServer.this.process(httpRequest, httpResponse);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    socket = null;
                    httpRequest = null;
                    httpResponse = null;
                }
            }
            catch (IOException iOException) {
                if (!HttpServer.this.myServerSocket.isClosed()) {
                    iOException.printStackTrace(System.err);
                }
                return;
            }
        }
    }
}

