/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Bullet;
import edu.rit.draw.item.ColorFill;
import edu.rit.draw.item.DrawingItem;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;

public class Text
extends DrawingItem
implements Externalizable {
    public static final Font NORMAL_FONT = new Font("sanserif", 0, 12);
    public static final Fill NORMAL_FILL = ColorFill.BLACK;
    public static final double NORMAL_SPACING = 1.1666666666666667;
    public static final Alignment NORMAL_ALIGNMENT = Alignment.LEFT;
    public static final Bullet NORMAL_BULLET = Bullet.NONE;
    private static final long serialVersionUID = -5562107126523082338L;
    static Font theDefaultFont = NORMAL_FONT;
    static Fill theDefaultFill = NORMAL_FILL;
    static double theDefaultSpacing = 1.1666666666666667;
    static Alignment theDefaultAlignment = NORMAL_ALIGNMENT;
    static Bullet theDefaultBullet = NORMAL_BULLET;
    String myText;
    Font myFont = theDefaultFont;
    Fill myFill = theDefaultFill;
    double mySpacing = theDefaultSpacing;
    Alignment myAlignment = theDefaultAlignment;
    Bullet myBullet = theDefaultBullet;
    double x;
    double y;
    double xFactor;
    double yFactor;
    Size mySize;
    AttributedString[] myLines;

    public Text() {
    }

    public Text(Text text) {
        super(text);
        this.myText = text.myText;
        this.myFont = text.myFont;
        this.myFill = text.myFill;
        this.mySpacing = text.mySpacing;
        this.myAlignment = text.myAlignment;
        this.myBullet = text.myBullet;
        this.x = text.x;
        this.y = text.y;
        this.xFactor = text.xFactor;
        this.yFactor = text.yFactor;
        this.mySize = text.mySize;
        if (text.myLines == null) {
            this.myLines = null;
        } else {
            int n = text.myLines.length;
            this.myLines = new AttributedString[n];
            for (int i = 0; i < n; ++i) {
                this.myLines[n] = new AttributedString(text.myLines[n].getIterator());
            }
        }
    }

    public static Font defaultFont() {
        return theDefaultFont;
    }

    public static void defaultFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        theDefaultFont = font;
    }

    public static Fill defaultFill() {
        return theDefaultFill;
    }

    public static void defaultFill(Fill fill) {
        if (fill == null) {
            throw new NullPointerException();
        }
        theDefaultFill = fill;
    }

    public static double defaultSpacing() {
        return theDefaultSpacing;
    }

    public static void defaultSpacing(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultSpacing = d;
    }

    public static Alignment defaultAlign() {
        return theDefaultAlignment;
    }

    public static void defaultAlign(Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException();
        }
        theDefaultAlignment = alignment;
    }

    public static Bullet defaultBullet() {
        return theDefaultBullet;
    }

    public static void defaultBullet(Bullet bullet) {
        theDefaultBullet = bullet;
    }

    public Text rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public Text rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public String text() {
        return this.myText;
    }

    public Text text(String string) {
        this.myText = string;
        this.mySize = null;
        this.myLines = null;
        return this;
    }

    public Font font() {
        return this.myFont;
    }

    public Text font(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.myFont = font;
        this.mySize = null;
        this.myLines = null;
        return this;
    }

    public Fill fill() {
        return this.myFill;
    }

    public Text fill(Fill fill) {
        if (fill == null) {
            throw new NullPointerException();
        }
        this.myFill = fill;
        return this;
    }

    public double spacing() {
        return this.mySpacing;
    }

    public Text spacing(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.mySpacing = d;
        this.mySize = null;
        return this;
    }

    public Alignment align() {
        return this.myAlignment;
    }

    public Text align(Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException();
        }
        this.myAlignment = alignment;
        return this;
    }

    public Bullet bullet() {
        return this.myBullet;
    }

    public Text bullet(Bullet bullet) {
        this.myBullet = bullet;
        return this;
    }

    public double width() {
        this.computeSize();
        return this.mySize.width;
    }

    public double height() {
        this.computeSize();
        return this.mySize.height;
    }

    public Point nw() {
        this.computeSize();
        return new Point(this.x + this.xFactor * this.mySize.width, this.y + this.yFactor * this.mySize.height);
    }

    public Text nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public Text nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public Text n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public Text n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public Text ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public Text ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public Text w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public Text w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public Text c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public Text c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public Text e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public Text e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public Text sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public Text sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public Text s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public Text s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public Text se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public Text se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public Text add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Text add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Text addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Text addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.myText);
        objectOutput.writeObject(this.myFont);
        objectOutput.writeObject(this.myFill);
        objectOutput.writeDouble(this.mySpacing);
        objectOutput.writeObject((Object)this.myAlignment);
        objectOutput.writeObject(this.myBullet);
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.xFactor);
        objectOutput.writeDouble(this.yFactor);
        objectOutput.writeObject(this.mySize);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myText = (String)objectInput.readObject();
        this.myFont = (Font)objectInput.readObject();
        this.myFill = (Fill)objectInput.readObject();
        this.mySpacing = objectInput.readDouble();
        this.myAlignment = (Alignment)((Object)objectInput.readObject());
        this.myBullet = (Bullet)objectInput.readObject();
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.xFactor = objectInput.readDouble();
        this.yFactor = objectInput.readDouble();
        this.mySize = (Size)objectInput.readObject();
        this.myLines = null;
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.myFont);
        this.myFill.setGraphicsContext(graphics2D);
        this.renderLines();
        int n = this.myLines.length;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout[] textLayoutArray = new TextLayout[n];
        for (int i = 0; i < n; ++i) {
            textLayoutArray[i] = new TextLayout(this.myLines[i].getIterator(), fontRenderContext);
        }
        double d = 0.0;
        for (TextLayout textLayout : textLayoutArray) {
            d = Math.max(d, textLayout.getBounds().getWidth());
        }
        LineMetrics lineMetrics = this.myFont.getLineMetrics("Eg", fontRenderContext);
        double d2 = lineMetrics.getAscent();
        double d3 = lineMetrics.getDescent();
        double d4 = this.mySpacing * (double)this.myFont.getSize2D();
        double d5 = n == 0 ? 0.0 : (double)(n - 1) * d4 + d2 + d3;
        double d6 = this.x + this.xFactor * d;
        double d7 = this.y + this.yFactor * d5;
        double d8 = 0.0;
        switch (this.myAlignment) {
            case LEFT: {
                d8 = 0.0;
                break;
            }
            case CENTER: {
                d8 = 0.5;
                break;
            }
            case RIGHT: {
                d8 = 1.0;
            }
        }
        for (int i = 0; i < n; ++i) {
            TextLayout textLayout = textLayoutArray[i];
            Rectangle2D rectangle2D = textLayout.getBounds();
            double d9 = rectangle2D.getWidth();
            double d10 = d6 + d8 * (d - d9);
            double d11 = d7 + (double)i * d4 + d2;
            textLayout.draw(graphics2D, (float)d10, (float)d11);
            if (i != 0 || this.myBullet == null) continue;
            this.myBullet.draw(graphics2D, d2, d10, d11);
        }
        graphics2D.setFont(font);
    }

    void computeSize() {
        if (this.mySize == null) {
            this.renderLines();
            int n = this.myLines.length;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            TextLayout[] textLayoutArray = new TextLayout[n];
            for (int i = 0; i < n; ++i) {
                textLayoutArray[i] = new TextLayout(this.myLines[i].getIterator(), fontRenderContext);
            }
            double d = 0.0;
            for (TextLayout textLayout : textLayoutArray) {
                d = Math.max(d, textLayout.getBounds().getWidth());
            }
            LineMetrics lineMetrics = this.myFont.getLineMetrics("Eg", fontRenderContext);
            double d2 = lineMetrics.getAscent();
            double d3 = lineMetrics.getDescent();
            double d4 = this.mySpacing * (double)this.myFont.getSize2D();
            double d5 = n == 0 ? 0.0 : (double)(n - 1) * d4 + d2 + d3;
            this.mySize = new Size(d, d5);
        }
    }

    void renderLines() {
        int n;
        int n2;
        int n3;
        CharSequence charSequence;
        int n4;
        Object object;
        if (this.myLines != null) {
            return;
        }
        String[] stringArray = this.myText == null ? new String[]{""} : this.myText.split("\n");
        int n5 = stringArray.length;
        this.myLines = new AttributedString[n5];
        for (int i = 0; i < n5; ++i) {
            object = stringArray[i];
            n4 = ((String)object).length();
            charSequence = new StringBuilder();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = ((String)object).charAt(n3);
                if (n2 == 60) {
                    n = ((String)object).indexOf(62, n3);
                    if (n == -1) {
                        n = n4 - 1;
                    }
                    n3 = n;
                    continue;
                }
                if (n2 == 38) {
                    String string;
                    n = ((String)object).indexOf(59, n3);
                    if (n == -1) {
                        n = n4 - 1;
                    }
                    if ((string = ((String)object).substring(n3, n + 1)).equals("&lt;")) {
                        ((StringBuilder)charSequence).append('<');
                    } else if (string.equals("&gt;")) {
                        ((StringBuilder)charSequence).append('>');
                    } else if (string.equals("&amp;")) {
                        ((StringBuilder)charSequence).append('&');
                    }
                    n3 = n;
                    continue;
                }
                ((StringBuilder)charSequence).append((char)n2);
            }
            this.myLines[i] = new AttributedString(((StringBuilder)charSequence).toString());
        }
        HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
        object = this.myFont.deriveFont(hashMap);
        for (n4 = 0; n4 < n5; ++n4) {
            charSequence = stringArray[n4];
            n3 = ((String)charSequence).length();
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                String string;
                int n6;
                char c = ((String)charSequence).charAt(n);
                if (c == '<') {
                    AffineTransform affineTransform;
                    n6 = ((String)charSequence).indexOf(62, n);
                    if (n6 == -1) {
                        n6 = n3 - 1;
                    }
                    if ((string = ((String)charSequence).substring(n, n6 + 1)).equalsIgnoreCase("<B>")) {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    } else if (string.equalsIgnoreCase("</B>")) {
                        hashMap.remove(TextAttribute.WEIGHT);
                    } else if (string.equalsIgnoreCase("<I>")) {
                        hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                    } else if (string.equalsIgnoreCase("</I>")) {
                        hashMap.remove(TextAttribute.POSTURE);
                        object = this.myFont.deriveFont(hashMap);
                    } else if (string.equalsIgnoreCase("<SUP>")) {
                        affineTransform = new AffineTransform();
                        affineTransform.scale(0.6666666666666666, 0.6666666666666666);
                        affineTransform.translate(0.0, (double)(-this.myFont.getSize2D()) * 2.0 / 3.0);
                        hashMap.put(TextAttribute.TRANSFORM, affineTransform);
                    } else if (string.equalsIgnoreCase("</SUP>")) {
                        hashMap.remove(TextAttribute.TRANSFORM);
                    } else if (string.equalsIgnoreCase("<SUB>")) {
                        affineTransform = new AffineTransform();
                        affineTransform.scale(0.6666666666666666, 0.6666666666666666);
                        affineTransform.translate(0.0, (double)this.myFont.getSize2D() / 3.0);
                        hashMap.put(TextAttribute.TRANSFORM, affineTransform);
                    } else if (string.equalsIgnoreCase("</SUB>")) {
                        hashMap.remove(TextAttribute.TRANSFORM);
                    }
                    object = this.myFont.deriveFont(hashMap);
                    n = n6;
                    continue;
                }
                if (c == '&') {
                    n6 = ((String)charSequence).indexOf(59, n);
                    if (n6 == -1) {
                        n6 = n3 - 1;
                    }
                    if ((string = ((String)charSequence).substring(n, n6 + 1)).equals("&lt;") || string.equals("&gt;") || string.equals("&amp;")) {
                        this.myLines[n4].addAttribute(TextAttribute.FONT, object, n2, n2 + 1);
                        ++n2;
                    }
                    n = n6;
                    continue;
                }
                this.myLines[n4].addAttribute(TextAttribute.FONT, object, n2, n2 + '\u0001');
                ++n2;
            }
        }
    }

    void doNw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = 0.0;
    }

    void doN(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = 0.0;
    }

    void doNe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = 0.0;
    }

    void doW(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -0.5;
    }

    void doC(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -0.5;
    }

    void doE(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -0.5;
    }

    void doSw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -1.0;
    }

    void doS(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -1.0;
    }

    void doSe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -1.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

