/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.FilledItem;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.Point;
import java.awt.Graphics2D;
import java.awt.Shape;

public abstract class ShapeItem
extends FilledItem {
    private static final long serialVersionUID = -1355208055025863586L;

    public ShapeItem() {
    }

    public ShapeItem(ShapeItem shapeItem) {
        super(shapeItem);
    }

    public ShapeItem rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public ShapeItem rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public ShapeItem outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public ShapeItem fill(Fill fill) {
        this.doFill(fill);
        return this;
    }

    public ShapeItem add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public ShapeItem add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public ShapeItem addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public ShapeItem addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        Shape shape = this.getShape();
        if (this.myFill != null) {
            this.myFill.setGraphicsContext(graphics2D);
            graphics2D.fill(shape);
        }
        if (this.myOutline != null) {
            this.myOutline.setGraphicsContext(graphics2D);
            graphics2D.draw(shape);
        }
    }

    abstract Shape getShape();
}

