/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.ShapeItem;
import edu.rit.draw.item.Size;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class RectangularItem
extends ShapeItem
implements Externalizable {
    private static final long serialVersionUID = 5803769800576180270L;
    double x;
    double y;
    double xFactor;
    double yFactor;
    double width;
    double height;

    public RectangularItem() {
    }

    public RectangularItem(RectangularItem rectangularItem) {
        super(rectangularItem);
        this.x = rectangularItem.x;
        this.y = rectangularItem.y;
        this.xFactor = rectangularItem.xFactor;
        this.yFactor = rectangularItem.yFactor;
        this.width = rectangularItem.width;
        this.height = rectangularItem.height;
    }

    public RectangularItem rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public RectangularItem rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public RectangularItem outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public RectangularItem fill(Fill fill) {
        this.doFill(fill);
        return this;
    }

    public RectangularItem size(Size size) {
        this.doSize(size);
        return this;
    }

    public double width() {
        return this.width;
    }

    public RectangularItem width(double d) {
        this.doWidth(d);
        return this;
    }

    public double height() {
        return this.height;
    }

    public RectangularItem height(double d) {
        this.doHeight(d);
        return this;
    }

    public Point nw() {
        return new Point(this.x + this.xFactor * this.width, this.y + this.yFactor * this.height);
    }

    public RectangularItem nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public RectangularItem nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public RectangularItem n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public RectangularItem n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public RectangularItem ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public RectangularItem ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public RectangularItem w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public RectangularItem w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public RectangularItem c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public RectangularItem c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public RectangularItem e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public RectangularItem e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public RectangularItem sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public RectangularItem sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public RectangularItem s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public RectangularItem s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public RectangularItem se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public RectangularItem se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public RectangularItem add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public RectangularItem add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public RectangularItem addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public RectangularItem addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.xFactor);
        objectOutput.writeDouble(this.yFactor);
        objectOutput.writeDouble(this.width);
        objectOutput.writeDouble(this.height);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.xFactor = objectInput.readDouble();
        this.yFactor = objectInput.readDouble();
        this.width = objectInput.readDouble();
        this.height = objectInput.readDouble();
    }

    void doSize(Size size) {
        if (size.width < 0.0 || size.height < 0.0) {
            throw new IllegalArgumentException();
        }
        this.width = size.width;
        this.height = size.height;
    }

    void doWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.width = d;
    }

    void doHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.height = d;
    }

    void doNw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = 0.0;
    }

    void doN(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = 0.0;
    }

    void doNe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = 0.0;
    }

    void doW(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -0.5;
    }

    void doC(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -0.5;
    }

    void doE(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -0.5;
    }

    void doSw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -1.0;
    }

    void doS(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -1.0;
    }

    void doSe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -1.0;
    }
}

