/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.RectangularItem;
import edu.rit.draw.item.Size;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public class Oval
extends RectangularItem {
    public static final double NORMAL_WIDTH = 72.0;
    public static final double NORMAL_HEIGHT = 72.0;
    private static final long serialVersionUID = -2803082960686823242L;
    private static double theDefaultWidth = 72.0;
    private static double theDefaultHeight = 72.0;

    public Oval() {
        this.width = theDefaultWidth;
        this.height = theDefaultHeight;
    }

    public Oval(Oval oval) {
        super(oval);
    }

    public static Size defaultSize() {
        return new Size(theDefaultWidth, theDefaultHeight);
    }

    public static void defaultSize(Size size) {
        if (size.width < 0.0 || size.height < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultWidth = size.width;
        theDefaultHeight = size.height;
    }

    public static double defaultWidth() {
        return theDefaultWidth;
    }

    public static void defaultWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultWidth = d;
    }

    public static double defaultHeight() {
        return theDefaultHeight;
    }

    public static void defaultHeight(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultHeight = d;
    }

    public Oval rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public Oval rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public Oval outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Oval fill(Fill fill) {
        this.doFill(fill);
        return this;
    }

    public Oval size(Size size) {
        this.doSize(size);
        return this;
    }

    public Oval width(double d) {
        this.doWidth(d);
        return this;
    }

    public Oval height(double d) {
        this.doHeight(d);
        return this;
    }

    public Oval nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public Oval nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public Oval n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public Oval n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public Oval ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public Oval ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public Oval w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public Oval w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public Oval c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public Oval c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public Oval e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public Oval e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public Oval sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public Oval sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public Oval s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public Oval s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public Oval se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public Oval se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public Oval add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Oval add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Oval addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Oval addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    Shape getShape() {
        Point point = this.nw();
        double d = Math.min(this.width, this.height);
        return new RoundRectangle2D.Double(point.x, point.y, this.width, this.height, d, d);
    }
}

