/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.DrawingItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Graphics2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class Group
extends DrawingItem
implements Externalizable {
    private static final long serialVersionUID = 166019465675783757L;
    ArrayList<DrawingItem> myItemList;
    double x;
    double y;
    double xFactor;
    double yFactor;
    Size mySize;
    double width;
    double height;
    double minX;
    double minY;

    public Group() {
        this.myItemList = new ArrayList();
    }

    public Group(Group group) {
        super(group);
        this.myItemList = new ArrayList<DrawingItem>(group.myItemList);
        this.x = group.x;
        this.y = group.y;
        this.xFactor = group.xFactor;
        this.yFactor = group.yFactor;
    }

    public Group clear() {
        this.myItemList.clear();
        this.mySize = null;
        return this;
    }

    public Group append(DrawingItem drawingItem) {
        if (drawingItem == null) {
            throw new NullPointerException();
        }
        this.myItemList.add(drawingItem);
        this.mySize = null;
        return this;
    }

    public Group prepend(DrawingItem drawingItem) {
        if (drawingItem == null) {
            throw new NullPointerException();
        }
        this.myItemList.add(0, drawingItem);
        this.mySize = null;
        return this;
    }

    public Group rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public Group rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public Size size() {
        this.computeSize();
        return this.mySize;
    }

    public double width() {
        this.computeSize();
        return this.width;
    }

    public double height() {
        this.computeSize();
        return this.height;
    }

    public Point nw() {
        this.computeSize();
        return new Point(this.x + this.xFactor * this.width, this.y + this.yFactor * this.height);
    }

    public Group nw(double d, double d2) {
        this.doNw(d, d2);
        return this;
    }

    public Group nw(Point point) {
        this.doNw(point.x, point.y);
        return this;
    }

    public Group n(double d, double d2) {
        this.doN(d, d2);
        return this;
    }

    public Group n(Point point) {
        this.doN(point.x, point.y);
        return this;
    }

    public Group ne(double d, double d2) {
        this.doNe(d, d2);
        return this;
    }

    public Group ne(Point point) {
        this.doNe(point.x, point.y);
        return this;
    }

    public Group w(double d, double d2) {
        this.doW(d, d2);
        return this;
    }

    public Group w(Point point) {
        this.doW(point.x, point.y);
        return this;
    }

    public Group c(double d, double d2) {
        this.doC(d, d2);
        return this;
    }

    public Group c(Point point) {
        this.doC(point.x, point.y);
        return this;
    }

    public Group e(double d, double d2) {
        this.doE(d, d2);
        return this;
    }

    public Group e(Point point) {
        this.doE(point.x, point.y);
        return this;
    }

    public Group sw(double d, double d2) {
        this.doSw(d, d2);
        return this;
    }

    public Group sw(Point point) {
        this.doSw(point.x, point.y);
        return this;
    }

    public Group s(double d, double d2) {
        this.doS(d, d2);
        return this;
    }

    public Group s(Point point) {
        this.doS(point.x, point.y);
        return this;
    }

    public Group se(double d, double d2) {
        this.doSe(d, d2);
        return this;
    }

    public Group se(Point point) {
        this.doSe(point.x, point.y);
        return this;
    }

    public Group add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Group add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Group addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Group addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        int n = this.myItemList.size();
        objectOutput.writeInt(n);
        for (DrawingItem drawingItem : this.myItemList) {
            objectOutput.writeObject(drawingItem);
        }
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.xFactor);
        objectOutput.writeDouble(this.yFactor);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myItemList.clear();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            this.myItemList.add((DrawingItem)objectInput.readObject());
        }
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.xFactor = objectInput.readDouble();
        this.yFactor = objectInput.readDouble();
        this.mySize = null;
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        this.computeSize();
        Point point = this.nw();
        graphics2D.translate(point.x - this.minX, point.y - this.minY);
        for (DrawingItem drawingItem : this.myItemList) {
            drawingItem.draw(graphics2D);
        }
    }

    private void computeSize() {
        if (this.mySize == null) {
            if (this.myItemList.isEmpty()) {
                this.minX = 0.0;
                this.minY = 0.0;
                this.width = 0.0;
                this.height = 0.0;
                this.mySize = new Size(0.0, 0.0);
            } else {
                this.minX = Double.MAX_VALUE;
                this.minY = Double.MAX_VALUE;
                double d = Double.MIN_VALUE;
                double d2 = Double.MIN_VALUE;
                for (DrawingItem drawingItem : this.myItemList) {
                    Point point = drawingItem.nw();
                    this.minX = Math.min(this.minX, point.x());
                    this.minY = Math.min(this.minY, point.y());
                    point = drawingItem.se();
                    d = Math.max(d, point.x());
                    d2 = Math.max(d2, point.y());
                }
                this.width = d - this.minX;
                this.height = d2 - this.minY;
                this.mySize = new Size(this.width, this.height);
            }
        }
    }

    void doNw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = 0.0;
    }

    void doN(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = 0.0;
    }

    void doNe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = 0.0;
    }

    void doW(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -0.5;
    }

    void doC(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -0.5;
    }

    void doE(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -0.5;
    }

    void doSw(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = 0.0;
        this.yFactor = -1.0;
    }

    void doS(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -0.5;
        this.yFactor = -1.0;
    }

    void doSe(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.xFactor = -1.0;
        this.yFactor = -1.0;
    }
}

