/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class DrawingItem
implements Externalizable {
    public static final Point NORMAL_ROTATION_CENTER;
    public static final double NORMAL_ROTATION_ANGLE = 0.0;
    private static final long serialVersionUID = -4091523056693860792L;
    static Point theDefaultRotationCenter;
    static double theDefaultRotationAngle;
    Point myRotationCenter = theDefaultRotationCenter;
    double myRotationAngle = theDefaultRotationAngle;

    public DrawingItem() {
    }

    public DrawingItem(DrawingItem drawingItem) {
        this.myRotationCenter = drawingItem.myRotationCenter;
        this.myRotationAngle = drawingItem.myRotationAngle;
    }

    public static Point defaultRotationCenter() {
        return theDefaultRotationCenter;
    }

    public static void defaultRotationCenter(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        theDefaultRotationCenter = point;
    }

    public static double defaultRotationAngle() {
        return theDefaultRotationAngle;
    }

    public static void defaultRotationAngle(double d) {
        theDefaultRotationAngle = d;
    }

    public Point rotationCenter() {
        return this.myRotationCenter;
    }

    public DrawingItem rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public double rotationAngle() {
        return this.myRotationAngle;
    }

    public DrawingItem rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public Size size() {
        return new Size(this.width(), this.height());
    }

    public abstract double width();

    public abstract double height();

    public abstract Point nw();

    public Point n() {
        return this.nw().add(0.5 * this.width(), 0.0);
    }

    public Point ne() {
        return this.nw().add(this.width(), 0.0);
    }

    public Point w() {
        return this.nw().add(0.0, 0.5 * this.height());
    }

    public Point c() {
        return this.nw().add(0.5 * this.width(), 0.5 * this.height());
    }

    public Point e() {
        return this.nw().add(this.width(), 0.5 * this.height());
    }

    public Point sw() {
        return this.nw().add(0.0, this.height());
    }

    public Point s() {
        return this.nw().add(0.5 * this.width(), this.height());
    }

    public Point se() {
        return this.nw().add(this.width(), this.height());
    }

    public DrawingItem add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public DrawingItem add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public DrawingItem addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public DrawingItem addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.myRotationCenter.writeExternal(objectOutput);
        objectOutput.writeDouble(this.myRotationAngle);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.myRotationCenter = new Point();
        this.myRotationCenter.readExternal(objectInput);
        this.myRotationAngle = objectInput.readDouble();
    }

    public void draw(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        this.concatenateTransform(affineTransform);
        graphics2D.setTransform(affineTransform);
    }

    public Rectangle2D boundingBox() {
        Point point = this.nw();
        return new Rectangle2D.Double(point.x, point.y, this.width(), this.height());
    }

    public Rectangle2D transformedBoundingBox() {
        Point point = this.transform(this.nw());
        Point point2 = this.transform(this.ne());
        Point point3 = this.transform(this.sw());
        Point point4 = this.transform(this.se());
        double d = Math.min(Math.min(point.x, point2.x), Math.min(point3.x, point4.x));
        double d2 = Math.max(Math.max(point.x, point2.x), Math.max(point3.x, point4.x));
        double d3 = Math.min(Math.min(point.y, point2.y), Math.min(point3.y, point4.y));
        double d4 = Math.max(Math.max(point.y, point2.y), Math.max(point3.y, point4.y));
        return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
    }

    public Point transform(Point point) {
        AffineTransform affineTransform = new AffineTransform();
        this.concatenateTransform(affineTransform);
        double[] dArray = new double[]{point.x, point.y};
        affineTransform.transform(dArray, 0, dArray, 0, 1);
        return new Point(dArray[0], dArray[1]);
    }

    void doRotationCenter(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.myRotationCenter = point;
    }

    void doRotationAngle(double d) {
        this.myRotationAngle = d;
    }

    void doAdd(Drawing drawing) {
        drawing.add(this);
    }

    void doAddFirst(Drawing drawing) {
        drawing.addFirst(this);
    }

    void concatenateTransform(AffineTransform affineTransform) {
        affineTransform.rotate(this.myRotationAngle, this.myRotationCenter.x, this.myRotationCenter.y);
    }

    static {
        theDefaultRotationCenter = NORMAL_ROTATION_CENTER = new Point();
        theDefaultRotationAngle = 0.0;
    }
}

