/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.item.ColorFill;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DottedOutline
implements Outline {
    public static final float NORMAL_WIDTH = 1.0f;
    public static final Fill NORMAL_FILL = ColorFill.BLACK;
    public static final DottedOutline NORMAL_OUTLINE = new DottedOutline();
    private static final long serialVersionUID = -5814995045228731216L;
    private float myWidth;
    private Fill myFill;
    private transient BasicStroke myStroke;

    public DottedOutline() {
        this.myWidth = 1.0f;
        this.myFill = NORMAL_FILL;
        this.computeStroke();
    }

    public DottedOutline(DottedOutline dottedOutline) {
        this.myWidth = dottedOutline.myWidth;
        this.myFill = dottedOutline.myFill;
        this.computeStroke();
    }

    public float width() {
        return this.myWidth;
    }

    public DottedOutline width(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.myWidth = f;
        this.computeStroke();
        return this;
    }

    public Fill fill() {
        return this.myFill;
    }

    public DottedOutline fill(Fill fill) {
        if (fill == null) {
            throw new NullPointerException();
        }
        this.myFill = fill;
        this.computeStroke();
        return this;
    }

    public float getStrokeWidth() {
        return this.myWidth;
    }

    public void setGraphicsContext(Graphics2D graphics2D) {
        graphics2D.setStroke(this.myStroke);
        this.myFill.setGraphicsContext(graphics2D);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.myWidth);
        objectOutput.writeObject(this.myFill);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.myWidth = objectInput.readFloat();
        this.myFill = (Fill)objectInput.readObject();
        this.computeStroke();
    }

    private void computeStroke() {
        this.myStroke = new BasicStroke(this.myWidth, 1, 0, 10.0f, new float[]{0.0f, 1.5f * this.myWidth}, 0.0f);
    }
}

