/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Bullet
implements Externalizable {
    private static final int BULLET_KIND_NONE = 0;
    private static final int BULLET_KIND_DOT = 1;
    private static final int BULLET_KIND_CIRCLE = 2;
    public static final double NORMAL_OFFSET = 36.0;
    public static final Bullet NONE = null;
    public static final Bullet DOT = new Bullet(1, 36.0);
    public static final Bullet CIRCLE = new Bullet(2, 36.0);
    private static final long serialVersionUID = 1799559688305790072L;
    private static final Info[] theBulletInfo = new Info[3];
    private int myKind;
    private double myOffset = theDefaultOffset;
    private static double theDefaultOffset;

    public Bullet() {
    }

    public Bullet(Bullet bullet) {
        this.myKind = bullet.myKind;
        this.myOffset = theDefaultOffset;
    }

    private Bullet(int n, double d) {
        this.myKind = n;
        this.myOffset = d;
    }

    public static double defaultOffset() {
        return theDefaultOffset;
    }

    public static void defaultOffset(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultOffset = d;
        Bullet.DOT.myOffset = d;
        Bullet.CIRCLE.myOffset = d;
    }

    public double offset() {
        return this.myOffset;
    }

    public Bullet offset(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myOffset = d;
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.myKind);
        objectOutput.writeDouble(this.myOffset);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.myKind = objectInput.readInt();
        this.myOffset = objectInput.readDouble();
        if (0 > this.myKind || this.myKind >= theBulletInfo.length) {
            throw new InvalidObjectException("Invalid bullet (kind = " + this.myKind + ")");
        }
    }

    public void draw(Graphics2D graphics2D, double d, double d2, double d3) {
        Info info;
        Info info2 = info = 0 <= this.myKind && this.myKind < theBulletInfo.length ? theBulletInfo[this.myKind] : null;
        if (info != null && info.theArea != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(d2 - this.myOffset, d3);
            affineTransform.scale(d, d);
            Area area = info.theArea.createTransformedArea(affineTransform);
            if (info.isFilled) {
                graphics2D.fill(area);
            }
            if (info.theOutlineWidth > 0.0f) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(info.theOutlineWidth));
                graphics2D.draw(area);
                graphics2D.setStroke(stroke);
            }
        }
    }

    static {
        Bullet.theBulletInfo[0] = new Info(null, false, 0.0f);
        Bullet.theBulletInfo[1] = new Info(new Area(new Ellipse2D.Double(0.0, -0.625, 0.5, 0.5)), true, 0.0f);
        Bullet.theBulletInfo[2] = new Info(new Area(new Ellipse2D.Double(0.0, -0.625, 0.5, 0.5)), false, 1.0f);
        theDefaultOffset = 36.0;
    }

    private static class Info {
        public Area theArea;
        public boolean isFilled;
        public float theOutlineWidth;

        public Info(Area area, boolean bl, float f) {
            this.theArea = area;
            this.isFilled = bl;
            this.theOutlineWidth = f;
        }
    }
}

