/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.OutlinedItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Arc
extends OutlinedItem
implements Externalizable {
    public static final Point NORMAL_CENTER;
    public static final double NORMAL_RADIUS = 1.0;
    public static final double NORMAL_START = 0.0;
    public static final double NORMAL_EXTENT = 1.5707963267948966;
    private static final long serialVersionUID = -6937810535765723224L;
    private static final double DEGREES_PER_RADIAN = 57.29577951308232;
    private static final double A_PI_2 = 1.5707963267948966;
    private static final double A_PI = Math.PI;
    private static final double A_3_PI_2 = 4.71238898038469;
    private static final double A_2_PI = Math.PI * 2;
    private static final double A_5_PI_2 = 7.853981633974483;
    private static final double A_3_PI = Math.PI * 3;
    private static final double A_7_PI_2 = 10.995574287564276;
    Point myCenter = theDefaultCenter;
    double myRadius = theDefaultRadius;
    double myStart = theDefaultStart;
    double myExtent = theDefaultExtent;
    static Point theDefaultCenter;
    static double theDefaultRadius;
    static double theDefaultStart;
    static double theDefaultExtent;
    Point myNw;
    Point mySe;
    Size mySize;

    public Arc() {
    }

    public Arc(Arc arc) {
        super(arc);
        this.myCenter = arc.myCenter;
        this.myRadius = arc.myRadius;
        this.myStart = arc.myStart;
        this.myExtent = arc.myExtent;
    }

    public static Point defaultCenter() {
        return theDefaultCenter;
    }

    public static void defaultCenter(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        theDefaultCenter = point;
    }

    public static double defaultRadius() {
        return theDefaultRadius;
    }

    public static void defaultRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultRadius = d;
    }

    public static double defaultStart() {
        return theDefaultStart;
    }

    public static void defaultStart(double d) {
        theDefaultStart = d;
    }

    public static double defaultExtent() {
        return theDefaultExtent;
    }

    public static void defaultExtent(double d) {
        theDefaultExtent = d;
    }

    public Arc rotationCenter(Point point) {
        this.doRotationCenter(point);
        return this;
    }

    public Arc rotationAngle(double d) {
        this.doRotationAngle(d);
        return this;
    }

    public Size size() {
        this.computeBoundingBox();
        return this.mySize;
    }

    public double width() {
        this.computeBoundingBox();
        return this.mySize.width;
    }

    public double height() {
        this.computeBoundingBox();
        return this.mySize.height;
    }

    public Point nw() {
        this.computeBoundingBox();
        return this.myNw;
    }

    public Arc outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Point center() {
        return this.myCenter;
    }

    public Arc center(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.myCenter = point;
        return this;
    }

    public double radius() {
        return this.myRadius;
    }

    public Arc radius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.myRadius = d;
        return this;
    }

    public double start() {
        return this.myStart;
    }

    public Arc start(double d) {
        this.myStart = d;
        return this;
    }

    public double extent() {
        return this.myExtent;
    }

    public Arc extent(double d) {
        this.myExtent = d;
        return this;
    }

    public Arc add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Arc add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Arc addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Arc addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.myCenter);
        objectOutput.writeDouble(this.myRadius);
        objectOutput.writeDouble(this.myStart);
        objectOutput.writeDouble(this.myExtent);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myCenter = (Point)objectInput.readObject();
        this.myRadius = objectInput.readDouble();
        this.myStart = objectInput.readDouble();
        this.myExtent = objectInput.readDouble();
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        Shape shape = this.computeShape();
        this.myOutline.setGraphicsContext(graphics2D);
        graphics2D.draw(shape);
    }

    private void computeBoundingBox() {
        if (this.myNw == null) {
            double d;
            double d2;
            if (this.myExtent >= 0.0) {
                d2 = this.myExtent;
                d = this.myStart;
            } else {
                d2 = -this.myExtent;
                d = this.myStart - d2;
            }
            double d3 = Math.abs(d);
            d3 -= Math.floor(d3 / (Math.PI * 2)) * (Math.PI * 2);
            if (d < 0.0) {
                d3 = Math.PI * 2 - d3;
            }
            double d4 = this.myCenter.x() + this.myRadius * Math.cos(d3);
            double d5 = this.myCenter.y() + this.myRadius * Math.sin(d3);
            double d6 = this.myCenter.x() + this.myRadius * Math.cos(d3 + d2);
            double d7 = this.myCenter.y() + this.myRadius * Math.sin(d3 + d2);
            double d8 = Math.min(d4, d6);
            double d9 = Math.min(d5, d7);
            double d10 = Math.max(d4, d6);
            double d11 = Math.max(d5, d7);
            if (d3 < Math.PI * 2 && d3 + d2 > Math.PI * 2) {
                d10 = this.myCenter.x() + this.myRadius;
            }
            if (d3 < 1.5707963267948966 && d3 + d2 > 1.5707963267948966 || d3 < 7.853981633974483 && d3 + d2 > 7.853981633974483) {
                d11 = this.myCenter.y() + this.myRadius;
            }
            if (d3 < Math.PI && d3 + d2 > Math.PI || d3 < Math.PI * 3 && d3 + d2 > Math.PI * 3) {
                d8 = this.myCenter.x() - this.myRadius;
            }
            if (d3 < 4.71238898038469 && d3 + d2 > 4.71238898038469 || d3 < 10.995574287564276 && d3 + d2 > 10.995574287564276) {
                d9 = this.myCenter.y() - this.myRadius;
            }
            this.myNw = new Point(d8, d9);
            this.mySe = new Point(d10, d11);
            this.mySize = this.mySe.difference(this.myNw);
        }
    }

    private Shape computeShape() {
        return new Arc2D.Double(this.myCenter.x() - this.myRadius, this.myCenter.y() - this.myRadius, 2.0 * this.myRadius, 2.0 * this.myRadius, -this.myStart * 57.29577951308232, -this.myExtent * 57.29577951308232, 0);
    }

    static {
        theDefaultCenter = NORMAL_CENTER = new Point(0.0, 0.0);
        theDefaultRadius = 1.0;
        theDefaultStart = 0.0;
        theDefaultExtent = 1.5707963267948966;
    }
}

