/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw;

import edu.rit.draw.item.ColorFill;
import edu.rit.draw.item.DrawingItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import edu.rit.swing.Displayable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.LinkedList;

public class Drawing
implements Externalizable,
Displayable {
    public static final Size AUTOMATIC_SIZE;
    public static final Size NORMAL_SIZE;
    public static final double NORMAL_BORDER = 2.0;
    public static final Alignment NORMAL_ALIGNMENT;
    public static final ColorFill NORMAL_BACKGROUND;
    private static final long serialVersionUID = 4731159386273550464L;
    private LinkedList<DrawingItem> myItems = new LinkedList();
    private Size mySize = NORMAL_SIZE;
    private double myBorder = 2.0;
    private Alignment myAlignment = NORMAL_ALIGNMENT;
    private ColorFill myBackground = NORMAL_BACKGROUND;
    private Point myItemsNW;
    private Point myItemsSE;
    private static Drawing theDefaultDrawing;

    public static Drawing defaultDrawing() {
        return theDefaultDrawing;
    }

    public static void defaultDrawing(Drawing drawing) {
        theDefaultDrawing = drawing;
    }

    public void add(DrawingItem drawingItem) {
        if (drawingItem == null) {
            throw new NullPointerException();
        }
        this.myItems.add(drawingItem);
    }

    public void addFirst(DrawingItem drawingItem) {
        if (drawingItem == null) {
            throw new NullPointerException();
        }
        this.myItems.addFirst(drawingItem);
    }

    public Size size() {
        return this.mySize;
    }

    public Drawing size(Size size) {
        this.mySize = size.width() <= 0.0 || size.height() <= 0.0 ? AUTOMATIC_SIZE : size;
        return this;
    }

    public double border() {
        return this.myBorder;
    }

    public Drawing border(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myBorder = d;
        return this;
    }

    public Alignment alignment() {
        return this.myAlignment;
    }

    public Drawing alignment(Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException();
        }
        this.myAlignment = alignment;
        return this;
    }

    public ColorFill background() {
        return this.myBackground;
    }

    public Drawing background(ColorFill colorFill) {
        if (colorFill == null) {
            throw new NullPointerException();
        }
        this.myBackground = colorFill;
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.myItems.size());
        for (DrawingItem drawingItem : this.myItems) {
            objectOutput.writeObject(drawingItem);
        }
        objectOutput.writeObject(this.mySize);
        objectOutput.writeDouble(this.myBorder);
        objectOutput.writeObject((Object)this.myAlignment);
        objectOutput.writeObject(this.myBackground);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.myItems.clear();
        for (int i = 0; i < n; ++i) {
            this.myItems.add((DrawingItem)objectInput.readObject());
        }
        this.mySize = (Size)objectInput.readObject();
        this.myBorder = objectInput.readDouble();
        this.myAlignment = (Alignment)((Object)objectInput.readObject());
        this.myBackground = (ColorFill)objectInput.readObject();
    }

    public static void write(String string) throws IOException {
        if (theDefaultDrawing != null) {
            Drawing.write(theDefaultDrawing, new File(string));
        }
    }

    public static void write(File file) throws IOException {
        if (theDefaultDrawing != null) {
            Drawing.write(theDefaultDrawing, file);
        }
    }

    public static void write(Drawing drawing, String string) throws IOException {
        Drawing.write(drawing, new File(string));
    }

    public static void write(Drawing drawing, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(drawing);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
    }

    public static Drawing read(String string) throws IOException, ClassNotFoundException {
        return Drawing.read(new File(string));
    }

    public static Drawing read(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        Drawing drawing = null;
        try {
            fileInputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(fileInputStream);
            drawing = (Drawing)objectInputStream.readObject();
            objectInputStream.close();
            return drawing;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw iOException;
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.computeItemsNWSE();
        Size size = this.myItemsSE.difference(this.myItemsNW);
        Size size2 = this.mySize.equals(AUTOMATIC_SIZE) ? size.add(2.0 * this.myBorder) : this.mySize;
        double d = size2.width() - size.width();
        double d2 = size2.height() - size.height();
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.myAlignment) {
            case NONE: {
                break;
            }
            case NORTHWEST: {
                d3 = this.myBorder - this.myItemsNW.x();
                d4 = this.myBorder - this.myItemsNW.y();
                break;
            }
            case NORTH: {
                d3 = 0.5 * d - this.myItemsNW.x();
                d4 = this.myBorder - this.myItemsNW.y();
                break;
            }
            case NORTHEAST: {
                d3 = d - this.myBorder - this.myItemsNW.x();
                d4 = this.myBorder - this.myItemsNW.y();
                break;
            }
            case WEST: {
                d3 = this.myBorder - this.myItemsNW.x();
                d4 = 0.5 * d2 - this.myItemsNW.y();
                break;
            }
            case CENTER: {
                d3 = 0.5 * d - this.myItemsNW.x();
                d4 = 0.5 * d2 - this.myItemsNW.y();
                break;
            }
            case EAST: {
                d3 = d - this.myBorder - this.myItemsNW.x();
                d4 = 0.5 * d2 - this.myItemsNW.y();
                break;
            }
            case SOUTHWEST: {
                d3 = this.myBorder - this.myItemsNW.x();
                d4 = d2 - this.myBorder - this.myItemsNW.y();
                break;
            }
            case SOUTH: {
                d3 = 0.5 * d - this.myItemsNW.x();
                d4 = d2 - this.myBorder - this.myItemsNW.y();
                break;
            }
            case SOUTHEAST: {
                d3 = d - this.myBorder - this.myItemsNW.x();
                d4 = d2 - this.myBorder - this.myItemsNW.y();
            }
        }
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        for (DrawingItem drawingItem : this.myItems) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(d3, d4);
            drawingItem.draw(graphics2D);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setTransform(affineTransform);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, object3);
    }

    public Rectangle2D getBoundingBox() {
        this.computeItemsNWSE();
        Size size = this.mySize.equals(AUTOMATIC_SIZE) ? this.myItemsSE.difference(this.myItemsNW).add(2.0 * this.myBorder) : this.mySize;
        return new Rectangle2D.Double(0.0, 0.0, size.width(), size.height());
    }

    public Paint getBackgroundPaint() {
        return this.myBackground.color();
    }

    private void computeItemsNWSE() {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        for (DrawingItem drawingItem : this.myItems) {
            rectangle2D = rectangle2D.createUnion(drawingItem.transformedBoundingBox());
        }
        this.myItemsNW = new Point(rectangle2D.getX(), rectangle2D.getY());
        this.myItemsSE = new Point(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
    }

    static {
        NORMAL_SIZE = AUTOMATIC_SIZE = new Size(0.0, 0.0);
        NORMAL_ALIGNMENT = Alignment.NORTHWEST;
        NORMAL_BACKGROUND = ColorFill.WHITE;
        theDefaultDrawing = new Drawing();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        NONE,
        NORTHWEST,
        NORTH,
        NORTHEAST,
        WEST,
        CENTER,
        EAST,
        SOUTHWEST,
        SOUTH,
        SOUTHEAST;

    }
}

