/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.timing;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.Comm;
import java.text.DecimalFormat;
import java.util.Date;

public class TimeBcast {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.00E0");

    private TimeBcast() {
    }

    public static void main(String[] stringArray) throws Throwable {
        int n;
        Comm.init(stringArray);
        Comm comm = Comm.world();
        int n2 = comm.size();
        int n3 = comm.rank();
        if (stringArray.length < 2) {
            TimeBcast.usage();
        }
        int n4 = Integer.parseInt(stringArray[0]);
        int n5 = stringArray.length - 1;
        int[] nArray = new int[n5];
        for (n = 0; n < n5; ++n) {
            nArray[n] = Integer.parseInt(stringArray[n + 1]);
        }
        if (n3 == 0) {
            System.out.println("java -Dpj.np=" + n2 + " edu.rit.clu.timing.TimeBcast " + n4);
            System.out.println(new Date());
            System.out.println("n (bytes)\ttime1 (msec)\ttime2 (msec)\tBcast time (sec)");
            for (n = 0; n < n5; ++n) {
                int n6 = nArray[n];
                byte[] byArray = new byte[n6];
                ByteBuf byteBuf = ByteBuf.buffer(byArray);
                long l = -System.currentTimeMillis();
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        byArray[j] = (byte)j;
                    }
                }
                l += System.currentTimeMillis();
                long l2 = -System.currentTimeMillis();
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        byArray[j] = (byte)j;
                    }
                    comm.broadcast(0, byteBuf);
                    comm.broadcast(1, byteBuf);
                }
                double d = (double)((l2 += System.currentTimeMillis()) - l) / (double)n4 / 2000.0;
                System.out.print(n6);
                System.out.print('\t');
                System.out.print(l);
                System.out.print('\t');
                System.out.print(l2);
                System.out.print('\t');
                System.out.print(FMT3.format(d));
                System.out.println();
            }
        } else {
            for (n = 0; n < n5; ++n) {
                int n7 = nArray[n];
                byte[] byArray = new byte[n7];
                ByteBuf byteBuf = ByteBuf.buffer(byArray);
                for (int i = 0; i < n4; ++i) {
                    comm.broadcast(0, byteBuf);
                    comm.broadcast(1, byteBuf);
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.timing.TimeBcast <reps> <n1> [<n2> ...]");
        System.err.println("<K> = Number of processors, K >= 2");
        System.err.println("<reps> = Number of repetitions for each value of <n>");
        System.err.println("<n1> = First value of <n>");
        System.err.println("<n2> = Second value of <n> . . .");
        System.exit(1);
    }
}

