/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.network;

import edu.rit.pj.Comm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydSeq {
    static int n;
    static double[][] d;

    private FloydSeq() {
    }

    public static void main(String[] stringArray) throws Throwable {
        int n;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length != 2) {
            FloydSeq.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        FloydSeq.n = dataInputStream.readInt();
        d = new double[FloydSeq.n][FloydSeq.n];
        for (int i = 0; i < FloydSeq.n; ++i) {
            double[] dArray = d[i];
            for (n = 0; n < FloydSeq.n; ++n) {
                dArray[n] = dataInputStream.readDouble();
            }
        }
        dataInputStream.close();
        long l2 = System.currentTimeMillis();
        for (n = 0; n < FloydSeq.n; ++n) {
            double[] dArray = d[n];
            for (int i = 0; i < FloydSeq.n; ++i) {
                double[] dArray2 = d[i];
                for (int j = 0; j < FloydSeq.n; ++j) {
                    dArray2[j] = Math.min(dArray2[j], dArray2[n] + dArray[j]);
                }
            }
        }
        long l3 = System.currentTimeMillis();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        dataOutputStream.writeInt(FloydSeq.n);
        for (int i = 0; i < FloydSeq.n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < FloydSeq.n; ++j) {
                dataOutputStream.writeDouble(dArray[j]);
            }
        }
        dataOutputStream.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.network.FloydSeq <infile> <outfile>");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

