/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.network;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.pj.Comm;
import edu.rit.util.Range;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;

public class FloydClu {
    static Comm world;
    static int size;
    static int rank;
    static int n;
    static double[][] d;

    private FloydClu() {
    }

    public static void main(String[] stringArray) throws Throwable {
        int n;
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            FloydClu.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (rank == 0) {
            object2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            FloydClu.n = ((DataInputStream)object2).readInt();
            d = new double[FloydClu.n][FloydClu.n];
            for (int i = 0; i < FloydClu.n; ++i) {
                object = d[i];
                for (n = 0; n < FloydClu.n; ++n) {
                    object[n] = ((DataInputStream)object2).readDouble();
                }
            }
            ((FilterInputStream)object2).close();
        }
        object2 = new IntegerItemBuf();
        ((IntegerItemBuf)object2).item = FloydClu.n;
        world.broadcast(0, (Buf)object2);
        FloydClu.n = ((IntegerItemBuf)object2).item;
        if (rank != 0) {
            d = new double[FloydClu.n][FloydClu.n];
        }
        Range[] rangeArray = new Range(0, FloydClu.n - 1).subranges(size);
        object = rangeArray[rank];
        n = ((Range)object).lb();
        int n2 = ((Range)object).ub();
        Buf[] bufArray = DoubleBuf.rowSliceBuffers(d, rangeArray);
        DoubleBuf doubleBuf = bufArray[rank];
        long l2 = System.currentTimeMillis();
        world.scatter(0, bufArray, doubleBuf);
        int n3 = 0;
        for (int i = 0; i < FloydClu.n; ++i) {
            double[] dArray = d[i];
            if (!rangeArray[n3].contains(i)) {
                ++n3;
            }
            world.broadcast(n3, DoubleBuf.buffer(dArray));
            for (int j = n; j <= n2; ++j) {
                double[] dArray2 = d[j];
                for (int k = 0; k < FloydClu.n; ++k) {
                    dArray2[k] = Math.min(dArray2[k], dArray2[i] + dArray[k]);
                }
            }
        }
        world.gather(0, doubleBuf, bufArray);
        long l3 = System.currentTimeMillis();
        if (rank == 0) {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            dataOutputStream.writeInt(FloydClu.n);
            for (int i = 0; i < FloydClu.n; ++i) {
                double[] dArray = d[i];
                for (int j = 0; j < FloydClu.n; ++j) {
                    dataOutputStream.writeDouble(dArray[j]);
                }
            }
            dataOutputStream.close();
        }
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.network.FloydClu <infile> <outfile>");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

